/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.mock;

import io.quarkus.panache.mock.PanacheStubber;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mockito.Mockito;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.invocation.DefaultInvocationFactory;
import org.mockito.internal.invocation.InterceptedInvocation;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PanacheMock {
    public static volatile boolean IsMockEnabled = false;
    private static final Map<Class<?>, Object> mocks = new ConcurrentHashMap();

    public static synchronized <T> T getMock(Class<T> klass) {
        return (T)mocks.get(klass);
    }

    public static synchronized Object[] getMocks(Class<?> ... classes) {
        Object[] mocks = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            mocks[i] = PanacheMock.getMock(classes[i]);
        }
        return mocks;
    }

    public static synchronized void mock(Class<?> ... classes) {
        for (Class<?> klass : classes) {
            mocks.computeIfAbsent(klass, v -> Mockito.mock((Class)klass));
        }
        IsMockEnabled = !mocks.isEmpty();
    }

    public static synchronized void reset() {
        mocks.clear();
        IsMockEnabled = false;
    }

    public static synchronized boolean isMocked(Class<?> klass) {
        return mocks.containsKey(klass);
    }

    public static Object mockMethod(Class<?> klass, String methodName, Class<?>[] parameterTypes, Object[] args) throws InvokeRealMethodException {
        try {
            Method invokedMethod = klass.getDeclaredMethod(methodName, parameterTypes);
            Object mock = PanacheMock.getMock(klass);
            MockCreationSettings settings = MockUtil.getMockSettings(mock);
            MyRealMethod myRealMethod = new MyRealMethod();
            InterceptedInvocation invocation = DefaultInvocationFactory.createInvocation(mock, (Method)invokedMethod, (Object[])args, (RealMethod)myRealMethod, (MockCreationSettings)settings, (Location)new LocationImpl(new Throwable(), true));
            MockHandler handler = MockUtil.getMockHandler(mock);
            return handler.handle((Invocation)invocation);
        }
        catch (InvokeRealMethodException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T verify(Class<T> klass) {
        return (T)Mockito.verify(PanacheMock.getMock(klass));
    }

    public static <T> T verify(Class<T> klass, VerificationMode verificationMode) {
        return (T)Mockito.verify(PanacheMock.getMock(klass), (VerificationMode)verificationMode);
    }

    public static void verifyNoMoreInteractions(Class<?> ... classes) {
        Mockito.verifyNoMoreInteractions((Object[])PanacheMock.getMocks(classes));
    }

    public static void verifyNoInteractions(Class<?> ... classes) {
        Mockito.verifyNoInteractions((Object[])PanacheMock.getMocks(classes));
    }

    public static PanacheStubber doAnswer(Answer answer) {
        return new PanacheStubber(Mockito.doAnswer((Answer)answer));
    }

    public static PanacheStubber doCallRealMethod() {
        return new PanacheStubber(Mockito.doCallRealMethod());
    }

    public static PanacheStubber doNothing() {
        return new PanacheStubber(Mockito.doNothing());
    }

    public static PanacheStubber doReturn(Object objectToBeReturned) {
        return new PanacheStubber(Mockito.doReturn((Object)objectToBeReturned));
    }

    public static PanacheStubber doReturn(Object objectToBeReturned, Object ... toBeReturnedNext) {
        return new PanacheStubber(Mockito.doReturn((Object)objectToBeReturned, (Object[])toBeReturnedNext));
    }

    public static PanacheStubber doThrow(Class<? extends Throwable> toBeThrown) {
        return new PanacheStubber(Mockito.doThrow(toBeThrown));
    }

    public static PanacheStubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... toBeThrownNext) {
        return new PanacheStubber(Mockito.doThrow(toBeThrown, (Class[])toBeThrownNext));
    }

    public static PanacheStubber doThrow(Throwable ... toBeThrown) {
        return new PanacheStubber(Mockito.doThrow((Throwable[])toBeThrown));
    }

    public static class MyRealMethod
    implements RealMethod {
        public boolean isInvokable() {
            return true;
        }

        public Object invoke() throws Throwable {
            throw new InvokeRealMethodException();
        }
    }

    public static class InvokeRealMethodException
    extends Exception {
    }
}

