/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.mock.impl;

import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.panache.common.deployment.PanacheConstants;
import io.quarkus.panache.mock.MockPanacheEntities;
import io.quarkus.panache.mock.PanacheMock;
import io.quarkus.test.component.QuarkusComponentTestCallbacks;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassVisitor;

public class PanacheQuarkusComponentTestCallbacks
implements QuarkusComponentTestCallbacks {
    private static final DotName PANACHE_ENTITY = DotName.createSimple((String)"io.quarkus.hibernate.orm.panache.PanacheEntity");
    private static final DotName PANACHE_ENTITY_BASE = DotName.createSimple((String)"io.quarkus.hibernate.orm.panache.PanacheEntityBase");

    public void beforeBuild(QuarkusComponentTestCallbacks.BeforeBuildContext buildContext) {
        Class testClass = buildContext.getTestClass();
        MockPanacheEntities panacheMocks = testClass.getAnnotation(MockPanacheEntities.class);
        if (panacheMocks == null || panacheMocks.value().length == 0) {
            return;
        }
        ArrayList<ClassInfo> mockedEntities = new ArrayList<ClassInfo>();
        for (Class<?> mockClass : panacheMocks.value()) {
            ClassInfo maybeMockedEntity = buildContext.getComputingBeanArchiveIndex().getClassByName(mockClass);
            DotName superName = maybeMockedEntity.superName();
            if (maybeMockedEntity.isAbstract() || superName == null || !superName.equals((Object)PANACHE_ENTITY) && !superName.equals((Object)PANACHE_ENTITY_BASE)) continue;
            mockedEntities.add(maybeMockedEntity);
        }
        HashMap<DotName, ArrayList<MethodInfo>> entityUserMethods = new HashMap<DotName, ArrayList<MethodInfo>>();
        for (ClassInfo entity : mockedEntities) {
            for (MethodInfo method : entity.methods()) {
                if (method.isSynthetic() || !Modifier.isStatic(method.flags()) || !Modifier.isPublic(method.flags())) continue;
                List<Object> userMethods = (List)entityUserMethods.get(entity.name());
                if (userMethods == null) {
                    userMethods = new ArrayList<MethodInfo>();
                    entityUserMethods.put(entity.name(), (ArrayList<MethodInfo>)userMethods);
                }
                userMethods.add(method);
            }
        }
        HashMap<DotName, ArrayList<MethodInfo>> entityGeneratedMethods = new HashMap<DotName, ArrayList<MethodInfo>>();
        ClassInfo panacheEntityBaseClassInfo = buildContext.getComputingBeanArchiveIndex().getClassByName(DotName.createSimple((String)"io.quarkus.hibernate.orm.panache.PanacheEntityBase"));
        for (ClassInfo entity : mockedEntities) {
            for (MethodInfo method : panacheEntityBaseClassInfo.methods()) {
                AnnotationInstance bridge;
                if (this.userMethodExists((List)entityUserMethods.get(entity.name()), method) || (bridge = method.annotation(PanacheConstants.DOTNAME_GENERATE_BRIDGE)) == null) continue;
                List<Object> generated = (List)entityGeneratedMethods.get(entity.name());
                if (generated == null) {
                    generated = new ArrayList<MethodInfo>();
                    entityGeneratedMethods.put(entity.name(), (ArrayList<MethodInfo>)generated);
                }
                generated.add(method);
            }
        }
        for (ClassInfo entity : mockedEntities) {
            List generatedMethods;
            String entityClassName = entity.name().toString();
            final ClassTransformer transformer = new ClassTransformer(entity.name().toString());
            List userMethods = (List)entityUserMethods.get(entity.name());
            if (userMethods != null) {
                for (MethodInfo userMethod : userMethods) {
                    transformer.removeMethod(MethodDescriptor.of((MethodInfo)userMethod));
                    this.addMethod(entityClassName, transformer, userMethod);
                }
            }
            if ((generatedMethods = (List)entityGeneratedMethods.get(entity.name())) != null) {
                for (MethodInfo generatedMethod : generatedMethods) {
                    this.addMethod(entityClassName, transformer, generatedMethod);
                }
            }
            buildContext.addBytecodeTransformer(new BytecodeTransformer(entityClassName, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String className, ClassVisitor originalVisitor) {
                    return transformer.applyTo(originalVisitor);
                }
            }));
        }
    }

    private void addMethod(String entityClass, ClassTransformer transformer, MethodInfo method) {
        MethodCreator transform = transformer.addMethod(MethodDescriptor.of((MethodInfo)method));
        transform.setModifiers(9);
        ResultHandle isMockEnabled = transform.readStaticField(FieldDescriptor.of(PanacheMock.class, (String)"IsMockEnabled", Boolean.TYPE));
        BytecodeCreator mockNotEnabled = transform.ifTrue(isMockEnabled).falseBranch();
        mockNotEnabled.throwException(RuntimeException.class, "Panache mock not enabled");
        ResultHandle isMocked = transform.invokeStaticMethod(MethodDescriptor.ofMethod(PanacheMock.class, (String)"isMocked", Boolean.TYPE, (Class[])new Class[]{Class.class}), new ResultHandle[]{transform.loadClass(entityClass)});
        BytecodeCreator notMocked = transform.ifTrue(isMocked).falseBranch();
        notMocked.throwException(RuntimeException.class, entityClass + " not mocked");
        ResultHandle entityClazz = transform.loadClass(entityClass);
        ResultHandle methodName = transform.load(method.name());
        ResultHandle paramTypes = transform.newArray(Class.class, method.parametersCount());
        for (int i = 0; i < method.parametersCount(); ++i) {
            transform.writeArrayValue(paramTypes, i, transform.loadClass(method.parameterType(i).name().toString()));
        }
        ResultHandle args = transform.newArray(Object.class, method.parametersCount());
        for (int i = 0; i < method.parametersCount(); ++i) {
            transform.writeArrayValue(args, i, transform.getMethodParam(i));
        }
        TryBlock tryInvoke = transform.tryBlock();
        ResultHandle ret = tryInvoke.invokeStaticMethod(MethodDescriptor.ofMethod(PanacheMock.class, (String)"mockMethod", Object.class, (Class[])new Class[]{Class.class, String.class, Class[].class, Object[].class}), new ResultHandle[]{entityClazz, methodName, paramTypes, args});
        tryInvoke.returnValue(ret);
        CatchBlockCreator catched = tryInvoke.addCatch(PanacheMock.InvokeRealMethodException.class);
        catched.throwException(RuntimeException.class, "Unstubbed method called: " + method.toString(), catched.getCaughtException());
    }

    public void afterStart(QuarkusComponentTestCallbacks.AfterStartContext afterStartContext) {
        Class testClass = afterStartContext.getTestClass();
        MockPanacheEntities panacheMocks = testClass.getAnnotation(MockPanacheEntities.class);
        if (panacheMocks == null || panacheMocks.value().length == 0) {
            return;
        }
        PanacheMock.mock(panacheMocks.value());
    }

    public void afterStop(QuarkusComponentTestCallbacks.AfterStopContext afterStopContext) {
        PanacheMock.reset();
    }

    private boolean userMethodExists(List<MethodInfo> userMethods, MethodInfo method) {
        if (userMethods == null || userMethods.isEmpty()) {
            return false;
        }
        String descriptor = method.descriptor();
        for (MethodInfo userMethod : userMethods) {
            if (!userMethod.descriptor().equals(descriptor)) continue;
            return true;
        }
        return false;
    }
}

