/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.picocli.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import picocli.CommandLine;

public class PicocliNativeImageProcessor {
    private static final Logger LOGGER = Logger.getLogger(PicocliNativeImageProcessor.class);

    @BuildStep(onlyIf={NativeBuild.class})
    void reflectionConfiguration(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageProxyDefinitionBuildItem> nativeImageProxies) {
        IndexView index = combinedIndexBuildItem.getIndex();
        List<DotName> annotationsToAnalyze = Arrays.asList(DotName.createSimple((String)CommandLine.ArgGroup.class.getName()), DotName.createSimple((String)CommandLine.Command.class.getName()), DotName.createSimple((String)CommandLine.Mixin.class.getName()), DotName.createSimple((String)CommandLine.Option.class.getName()), DotName.createSimple((String)CommandLine.Parameters.class.getName()), DotName.createSimple((String)CommandLine.ParentCommand.class.getName()), DotName.createSimple((String)CommandLine.Spec.class.getName()), DotName.createSimple((String)CommandLine.Unmatched.class.getName()));
        HashSet<ClassInfo> foundClasses = new HashSet<ClassInfo>();
        HashSet<FieldInfo> foundFields = new HashSet<FieldInfo>();
        for (DotName analyzedAnnotation : annotationsToAnalyze) {
            block7: for (AnnotationInstance ann : index.getAnnotations(analyzedAnnotation)) {
                AnnotationTarget target = ann.target();
                switch (target.kind()) {
                    case CLASS: {
                        foundClasses.add(target.asClass());
                        continue block7;
                    }
                    case FIELD: {
                        foundFields.add(target.asField());
                        foundClasses.add(target.asField().declaringClass());
                        continue block7;
                    }
                    case METHOD: {
                        foundClasses.add(target.asMethod().declaringClass());
                        continue block7;
                    }
                    case METHOD_PARAMETER: {
                        foundClasses.add(target.asMethodParameter().method().declaringClass());
                        continue block7;
                    }
                }
                LOGGER.warnf("Unsupported type %s annotated with %s", (Object)target.kind().name(), (Object)analyzedAnnotation);
            }
        }
        Arrays.asList(DotName.createSimple((String)CommandLine.IVersionProvider.class.getName()), DotName.createSimple((String)CommandLine.class.getName())).forEach(interfaceName -> foundClasses.addAll(index.getAllKnownImplementors(interfaceName)));
        foundClasses.forEach(classInfo -> {
            if (Modifier.isInterface(classInfo.flags())) {
                nativeImageProxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{classInfo.name().toString()}));
                reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, new String[]{classInfo.name().toString()}));
            } else {
                reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{classInfo.name().toString()}));
            }
        });
        foundFields.forEach(fieldInfo -> reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(fieldInfo)));
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void resourceBundlesConfiguration(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundles) {
        combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)CommandLine.Command.class.getName())).stream().map(ann -> ann.value("resourceBundle")).filter(Objects::nonNull).map(AnnotationValue::asString).filter(stringVal -> stringVal != null && !stringVal.isEmpty()).collect(Collectors.toSet()).forEach(bundleName -> resourceBundles.produce((BuildItem)new NativeImageResourceBundleBuildItem(bundleName)));
    }
}

