/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.picocli.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.picocli.deployment.PicocliDeploymentConfiguration;
import io.quarkus.picocli.runtime.DefaultPicocliCommandLineFactory;
import io.quarkus.picocli.runtime.PicocliConfigBuilder;
import io.quarkus.picocli.runtime.PicocliRunner;
import io.quarkus.picocli.runtime.annotations.TopCommand;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import picocli.CommandLine;

class PicocliProcessor {
    PicocliProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.PICOCLI);
    }

    @BuildStep
    BeanDefiningAnnotationBuildItem commandBeanDefiningAnnotation() {
        return new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)CommandLine.Command.class.getName()));
    }

    @BuildStep
    IndexDependencyBuildItem picocliIndexDependency() {
        return new IndexDependencyBuildItem("info.picocli", "picocli");
    }

    @BuildStep
    void configBuilder(PicocliDeploymentConfiguration configuration, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        if (configuration.disableDefaultConfigSources) {
            staticInitConfigBuilder.produce((BuildItem)new StaticInitConfigBuilderBuildItem(PicocliConfigBuilder.class.getName()));
            runTimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(PicocliConfigBuilder.class.getName()));
        }
    }

    @BuildStep
    void picocliRunner(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<QuarkusApplicationClassBuildItem> quarkusApplicationClass, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        List<DotName> commands;
        IndexView index = combinedIndex.getIndex();
        List<DotName> topCommands = this.classesAnnotatedWith(index, TopCommand.class.getName());
        if (topCommands.isEmpty() && (commands = this.classesAnnotatedWith((IndexView)applicationIndex.getIndex(), CommandLine.Command.class.getName())).size() == 1) {
            annotationsTransformer.produce((BuildItem)this.createAnnotationTransformer(commands.get(0)));
        }
        if (index.getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName())).isEmpty()) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PicocliRunner.class));
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DefaultPicocliCommandLineFactory.class));
            quarkusApplicationClass.produce((BuildItem)new QuarkusApplicationClassBuildItem(PicocliRunner.class));
        }
    }

    private AnnotationsTransformerBuildItem createAnnotationTransformer(final DotName className) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo target = context.getTarget().asClass();
                if (target.name().equals((Object)className)) {
                    ((Transformation)context.transform().add(TopCommand.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    private List<DotName> classesAnnotatedWith(IndexView indexView, String annotationClassName) {
        return indexView.getAnnotations(DotName.createSimple((String)annotationClassName)).stream().filter(ann -> ann.target().kind() == AnnotationTarget.Kind.CLASS).map(ann -> ann.target().asClass().name()).collect(Collectors.toList());
    }
}

