/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.picocli.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.QuarkusApplicationClassBuildItem;
import io.quarkus.picocli.runtime.DefaultPicocliCommandLineFactory;
import io.quarkus.picocli.runtime.PicocliRunner;
import io.quarkus.picocli.runtime.annotations.TopCommand;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import picocli.CommandLine;

class PicocliProcessor {
    PicocliProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.PICOCLI);
    }

    @BuildStep
    void addScopeToCommands(BuildProducer<AutoAddScopeBuildItem> autoAddScope) {
        autoAddScope.produce((BuildItem)AutoAddScopeBuildItem.builder().isAnnotatedWith(DotName.createSimple((String)CommandLine.Command.class.getName())).requiresContainerServices().defaultScope(BuiltinScope.DEPENDENT).priority(20).unremovable().build());
        autoAddScope.produce((BuildItem)AutoAddScopeBuildItem.builder().match((clazz, annotations, index) -> {
            List constructors = clazz.methods().stream().filter(m -> m.name().equals("<init>")).collect(Collectors.toList());
            return constructors.size() == 1 && ((MethodInfo)constructors.get(0)).parametersCount() > 0;
        }).isAnnotatedWith(DotName.createSimple((String)CommandLine.Command.class.getName())).defaultScope(BuiltinScope.DEPENDENT).priority(10).unremovable().build());
        autoAddScope.produce((BuildItem)AutoAddScopeBuildItem.builder().isAnnotatedWith(DotName.createSimple((String)TopCommand.class.getName())).defaultScope(BuiltinScope.DEPENDENT).unremovable().build());
    }

    @BuildStep
    IndexDependencyBuildItem picocliIndexDependency() {
        return new IndexDependencyBuildItem("info.picocli", "picocli");
    }

    @BuildStep
    void picocliRunner(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovableBean, BuildProducer<QuarkusApplicationClassBuildItem> quarkusApplicationClass, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        List<DotName> commands;
        IndexView index = combinedIndex.getIndex();
        List<DotName> topCommands = this.classesAnnotatedWith(index, TopCommand.class.getName());
        if (topCommands.isEmpty() && (commands = this.classesAnnotatedWith((IndexView)applicationIndex.getIndex(), CommandLine.Command.class.getName())).size() == 1) {
            DotName singleCommandClassName = commands.get(0);
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationsTransformer.ClassTransformerBuilder)AnnotationsTransformer.appliedToClass().whenClass(c -> c.name().equals((Object)singleCommandClassName)).priority(2000)).thenTransform(t -> t.add(TopCommand.class, new AnnotationValue[0]))));
        }
        if (index.getAnnotations(DotName.createSimple((String)QuarkusMain.class.getName())).isEmpty()) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PicocliRunner.class));
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DefaultPicocliCommandLineFactory.class));
            quarkusApplicationClass.produce((BuildItem)new QuarkusApplicationClassBuildItem(PicocliRunner.class));
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{CommandLine.ITypeConverter.class, CommandLine.IVersionProvider.class, CommandLine.IModelTransformer.class, CommandLine.IModelTransformer.class, CommandLine.IDefaultValueProvider.class, CommandLine.IParameterConsumer.class, CommandLine.IParameterPreprocessor.class, CommandLine.INegatableOptionTransformer.class, CommandLine.IHelpFactory.class}));
    }

    private List<DotName> classesAnnotatedWith(IndexView indexView, String annotationClassName) {
        return indexView.getAnnotations(DotName.createSimple((String)annotationClassName)).stream().filter(ann -> ann.target().kind() == AnnotationTarget.Kind.CLASS).map(ann -> ann.target().asClass().name()).collect(Collectors.toList());
    }
}

