/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

class ProjectReleaseImpl
implements ProjectRelease {
    protected final ScmRevision id;
    protected List<ProjectDependency> deps;
    protected final Set<String> artifactVersions = new HashSet<String>();
    protected final Set<String> groupIds = new HashSet<String>(1);

    public static Builder builder(ScmRevision id) {
        return new ProjectReleaseImpl(id).new Builder();
    }

    public static ProjectRelease create(ScmRevision id, List<ProjectDependency> deps) {
        return new ProjectReleaseImpl(id, deps == null ? List.of() : Collections.unmodifiableList(deps));
    }

    private ProjectReleaseImpl(ScmRevision id) {
        this(id, null);
    }

    private ProjectReleaseImpl(ScmRevision id, List<ProjectDependency> deps) {
        this.id = id;
        this.deps = deps == null ? List.of() : deps;
    }

    @Override
    public ScmRevision id() {
        return this.id;
    }

    @Override
    public Collection<ProjectDependency> dependencies() {
        return this.deps;
    }

    @Override
    public Collection<String> artifactVersions() {
        return this.artifactVersions;
    }

    @Override
    public Collection<String> groupIds() {
        return this.groupIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deps == null ? 0 : this.deps.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectReleaseImpl other = (ProjectReleaseImpl)obj;
        if (this.deps == null ? other.deps != null : !this.deps.equals(other.deps)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public class Builder
    implements ProjectRelease.Builder {
        private LinkedHashMap<ArtifactKey, ProjectDependency> deps = new LinkedHashMap();

        private Builder() {
        }

        @Override
        public ScmRevision id() {
            return ProjectReleaseImpl.this.id;
        }

        @Override
        public ProjectRelease.Builder add(ProjectDependency dep, BiFunction<ProjectDependency, ProjectDependency, ProjectDependency> conflictResolver) {
            ProjectDependency existing = this.deps.put(dep.key(), dep);
            if (existing == null) {
                ProjectReleaseImpl.this.artifactVersions.add(dep.artifact().getVersion());
            } else if (!dep.artifact().getVersion().equals(existing.artifact().getVersion())) {
                if (conflictResolver == null) {
                    throw new IllegalArgumentException("Failed to add " + dep + " since the release already includes " + existing);
                }
                ProjectDependency preferred = conflictResolver.apply(dep, existing);
                if (preferred == existing) {
                    dep = existing;
                    this.deps.put(dep.key(), dep);
                }
            }
            ProjectReleaseImpl.this.artifactVersions.add(dep.artifact().getVersion());
            ProjectReleaseImpl.this.groupIds.add(dep.artifact.getGroupId());
            return this;
        }

        @Override
        public ProjectRelease.Builder add(Artifact a) {
            return this.add(ProjectDependency.create(ProjectReleaseImpl.this.id, a));
        }

        @Override
        public ProjectRelease.Builder add(Dependency d) {
            return this.add(ProjectDependency.create(ProjectReleaseImpl.this.id, d));
        }

        @Override
        public boolean includes(ArtifactKey key) {
            return this.deps.containsKey(key);
        }

        @Override
        public Collection<ProjectDependency> dependencies() {
            return this.deps.values();
        }

        @Override
        public Collection<String> artifactVersions() {
            return ProjectReleaseImpl.this.artifactVersions;
        }

        @Override
        public Collection<String> groupIds() {
            return ProjectReleaseImpl.this.groupIds;
        }

        @Override
        public ProjectRelease build() {
            ProjectReleaseImpl.this.deps = List.copyOf(this.deps.values());
            return ProjectReleaseImpl.this;
        }
    }
}

