/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class ProjectDependency {
    protected final ScmRevision releaseId;
    protected final Artifact artifact;
    protected Dependency bomDependency;
    protected UpdateStatus updateStatus = UpdateStatus.UNKNOWN;
    protected ProjectDependency availableUpdate;
    protected boolean preferredVersion;
    private ArtifactKey key;

    public static ProjectDependency create(ScmRevision releaseId, Artifact artifact) {
        return ProjectDependency.create(releaseId, new Dependency(artifact, null));
    }

    public static ProjectDependency create(ScmRevision releaseId, Dependency dep) {
        return new ProjectDependency(releaseId, dep);
    }

    private ProjectDependency(ScmRevision releaseId, Dependency dep) {
        this.releaseId = Objects.requireNonNull(releaseId);
        this.bomDependency = Objects.requireNonNull(dep);
        this.artifact = Objects.requireNonNull(dep.getArtifact());
    }

    public ScmRevision releaseId() {
        return this.releaseId;
    }

    public Dependency dependency() {
        return this.bomDependency;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public boolean isPreferredVersion() {
        return this.preferredVersion;
    }

    public UpdateStatus updateStatus() {
        return this.updateStatus;
    }

    public ProjectDependency availableUpdate() {
        return this.availableUpdate;
    }

    public boolean isUpdateAvailable() {
        return this.availableUpdate != null;
    }

    public void setAvailableUpdate(ProjectDependency update) {
        if (update != null) {
            this.updateStatus = UpdateStatus.AVAILABLE;
            this.availableUpdate = update;
        }
    }

    protected void setUpdateUnavailable() {
        this.updateStatus = UpdateStatus.UNAVAILABLE;
        this.availableUpdate = null;
    }

    public ArtifactKey key() {
        return this.key == null ? (this.key = ArtifactKey.of((String)this.artifact.getGroupId(), (String)this.artifact.getArtifactId(), (String)this.artifact.getClassifier(), (String)this.artifact.getExtension())) : this.key;
    }

    public String toString() {
        return this.artifact.toString();
    }

    public static enum UpdateStatus {
        UNKNOWN,
        AVAILABLE,
        UNAVAILABLE;

    }
}

