/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.NoopDecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public class UpdateAvailabilityTransformer
implements DecomposedBomTransformer {
    private final ArtifactResolver resolver;
    private final MessageWriter log;

    public UpdateAvailabilityTransformer(ArtifactResolver resolver, MessageWriter log) {
        this.resolver = Objects.requireNonNull(resolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public DecomposedBom transform(DecomposedBom decomposedBom) throws BomDecomposerException {
        this.log.debug("Transforming decomposed %s", new Object[]{decomposedBom.bomArtifact()});
        decomposedBom.visit(new NoopDecomposedBomVisitor(true){
            List<ProjectRelease> releases;
            {
                this.releases = new ArrayList<ProjectRelease>();
            }

            @Override
            public void leaveReleaseOrigin(ScmRepository releaseOrigin) throws BomDecomposerException {
                ArrayList<DefaultArtifactVersion> releaseVersions = new ArrayList<DefaultArtifactVersion>();
                HashMap<DefaultArtifactVersion, ScmRevision> versionToReleaseId = new HashMap<DefaultArtifactVersion, ScmRevision>();
                for (ProjectRelease release : this.releases) {
                    for (String versionStr : release.artifactVersions()) {
                        DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                        releaseVersions.add(version);
                        ScmRevision prevReleaseId = versionToReleaseId.put(version, release.id());
                        if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.getValue()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().getValue())) <= 0) continue;
                        versionToReleaseId.put(version, prevReleaseId);
                    }
                }
                Collections.sort(releaseVersions);
                for (ProjectRelease release : this.releases) {
                    for (ProjectDependency dep : release.dependencies()) {
                        int i = releaseVersions.size() - 1;
                        if (release.id().equals(versionToReleaseId.get(releaseVersions.get(i)))) {
                            dep.preferredVersion = true;
                            continue;
                        }
                        while (i >= 0) {
                            ArtifactVersion version = (ArtifactVersion)releaseVersions.get(i--);
                            ScmRevision releaseId = (ScmRevision)versionToReleaseId.get(version);
                            if (release.id().equals(releaseId)) break;
                            Artifact updatedArtifact = dep.artifact().setVersion(version.toString());
                            if (!UpdateAvailabilityTransformer.this.isAvailable(updatedArtifact)) continue;
                            dep.setAvailableUpdate(ProjectDependency.create(releaseId, dep.dependency().setArtifact(updatedArtifact)));
                            break;
                        }
                        if (dep.updateStatus() != ProjectDependency.UpdateStatus.UNKNOWN) continue;
                        dep.setUpdateUnavailable();
                    }
                }
                this.releases.clear();
            }

            @Override
            public void visitProjectRelease(ProjectRelease release) {
                this.releases.add(release);
            }
        });
        this.log.debug("Transformed decomposed BOM %s", new Object[]{decomposedBom.bomArtifact()});
        return decomposedBom;
    }

    private boolean isAvailable(Artifact artifact) {
        return this.resolver.resolveOrNull(artifact) != null;
    }
}

