/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;

public class DecomposedBom {
    protected PomResolver bomSource;
    protected Artifact bomArtifact;
    protected Map<ScmRepository, Map<ScmRevision, ProjectRelease>> releases = new HashMap<ScmRepository, Map<ScmRevision, ProjectRelease>>();

    public static Builder builder() {
        return new DecomposedBom().new Builder();
    }

    private DecomposedBom() {
    }

    public String bomSource() {
        return this.bomSource == null ? "n/a" : this.bomSource.source();
    }

    public Artifact bomArtifact() {
        return this.bomArtifact;
    }

    public PomResolver bomResolver() {
        return this.bomSource;
    }

    public boolean includes(ScmRepository origin) {
        return this.releases.containsKey(origin);
    }

    public Collection<ScmRevision> releaseVersions(ScmRepository origin) {
        return this.releases.getOrDefault(origin, Map.of()).keySet();
    }

    public Collection<ProjectRelease> releases(ScmRepository origin) {
        return this.releases.getOrDefault(origin, Map.of()).values();
    }

    public ProjectRelease releaseOrNull(ScmRevision releaseId) {
        return (ProjectRelease)this.releases.getOrDefault(releaseId.getRepository(), Map.of()).get(releaseId);
    }

    public Iterable<ProjectRelease> releases() {
        final Iterator<Map<ScmRevision, ProjectRelease>> origins = this.releases.values().iterator();
        return new Iterable<ProjectRelease>(){

            @Override
            public Iterator<ProjectRelease> iterator() {
                return new Iterator<ProjectRelease>(){
                    Iterator<ProjectRelease> releases;

                    @Override
                    public boolean hasNext() {
                        return this.releases != null && this.releases.hasNext() || origins.hasNext();
                    }

                    @Override
                    public ProjectRelease next() {
                        if (this.releases == null || !this.releases.hasNext()) {
                            this.releases = ((Map)origins.next()).values().iterator();
                        }
                        return this.releases.next();
                    }
                };
            }
        };
    }

    public void visit(DecomposedBomVisitor visitor) throws BomDecomposerException {
        visitor.enterBom(this.bomArtifact);
        ArrayList<ScmRepository> origins = new ArrayList<ScmRepository>(this.releases.keySet());
        for (ScmRepository origin : origins) {
            Collection<ProjectRelease> releaseVersions;
            if (!visitor.enterReleaseOrigin(origin, (releaseVersions = this.releases.get(origin).values()).size())) continue;
            for (ProjectRelease v : releaseVersions) {
                visitor.visitProjectRelease(v);
            }
            visitor.leaveReleaseOrigin(origin);
        }
        visitor.leaveBom();
    }

    public class Builder {
        private Builder() {
        }

        public Builder bomSource(PomResolver bom) {
            DecomposedBom.this.bomSource = bom;
            return this;
        }

        public Builder bomArtifact(Artifact bom) {
            DecomposedBom.this.bomArtifact = bom;
            return this;
        }

        public Artifact getBomArtifact() {
            return DecomposedBom.this.bomArtifact;
        }

        public Builder addRelease(ProjectRelease release) {
            DecomposedBom.this.releases.computeIfAbsent(release.id().getRepository(), t -> new HashMap()).put(release.id(), release);
            return this;
        }

        public DecomposedBom build() {
            return DecomposedBom.this;
        }
    }
}

