/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class ApacheHttpComponentsReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (!artifact.getGroupId().equals("org.apache.httpcomponents")) {
            return null;
        }
        ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
        if (!releaseId.getRepository().hasUrl()) {
            return null;
        }
        String origin = releaseId.getRepository().getUrl();
        int i = origin.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        String repoName = origin.substring(i + 1);
        Object version = artifact.getVersion();
        version = repoName.equals("httpcomponents-parent") && ((String)version).equals("11") ? (String)version + "-RC1" : "rel/v" + (String)version;
        return ScmRevision.tag(ScmRepository.ofUrl("https://github.com/apache/" + repoName), (String)version);
    }
}

