/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.scm;

import io.quarkus.bom.decomposer.ReleaseOrigin;
import java.util.Objects;

public class ScmRepository
implements ReleaseOrigin {
    private final String id;
    private final String url;

    public static ScmRepository ofUrl(String url) {
        return new ScmRepository(url, url);
    }

    public static ScmRepository ofId(String id) {
        return new ScmRepository(id, null);
    }

    private ScmRepository(String id, String url) {
        this.id = Objects.requireNonNull(id, "ID is null");
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean isUrl() {
        return this.hasUrl();
    }

    public String getUrl() {
        if (!this.hasUrl()) {
            throw new RuntimeException(this.id + " was not initialized with a URL");
        }
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScmRepository that = (ScmRepository)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url);
    }

    public String toString() {
        return this.id;
    }
}

