/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom;

import io.quarkus.bom.PomResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;

public class RepositoryPomResolver
implements PomResolver {
    private final Artifact pomArtifact;
    private Model model;

    public RepositoryPomResolver(Artifact pomArtifact) {
        this.pomArtifact = pomArtifact;
    }

    @Override
    public Path pomPath() {
        if (this.isResolved()) {
            return this.pomArtifact.getFile().toPath();
        }
        throw new RuntimeException(String.valueOf(this.pomArtifact) + " has not been resolved");
    }

    @Override
    public String source() {
        return this.pomArtifact.toString();
    }

    @Override
    public Model model() throws IOException {
        return this.model == null ? (this.model = ModelUtils.readModel((Path)this.pomPath())) : this.model;
    }

    @Override
    public Model readLocalModel(Path pom) throws IOException {
        if (Files.isSameFile(pom, this.pomPath())) {
            return this.model();
        }
        throw new IllegalArgumentException("This implementation supports only " + String.valueOf(this.pomPath()) + ": " + String.valueOf(pom));
    }

    @Override
    public Artifact pomArtifact() {
        return this.pomArtifact;
    }

    @Override
    public boolean isResolved() {
        return this.pomArtifact.getFile() != null;
    }
}

