/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.FileReportWriter;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.domino.scm.ScmRepository;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.aether.artifact.Artifact;

public abstract class DecomposedBomReportFileWriter
extends FileReportWriter
implements DecomposedBomVisitor {
    public DecomposedBomReportFileWriter(String name) {
        super(name);
    }

    public DecomposedBomReportFileWriter(Path p) {
        super(p);
    }

    @Override
    public void enterBom(Artifact bomArtifact) {
        try {
            this.writeStartBom(this.writer(), bomArtifact);
        }
        catch (Exception e) {
            this.close();
            throw new IllegalStateException("Failed to init " + String.valueOf(this.reportFile) + " writer", e);
        }
    }

    protected abstract void writeStartBom(BufferedWriter var1, Artifact var2) throws IOException;

    @Override
    public boolean enterReleaseOrigin(ScmRepository releaseOrigin, int versions) {
        try {
            return this.writeStartReleaseOrigin(this.writer(), releaseOrigin, versions);
        }
        catch (Exception e) {
            this.close();
            throw new IllegalStateException("Failed to write release origin " + String.valueOf(releaseOrigin) + " to " + String.valueOf(this.reportFile), e);
        }
    }

    protected abstract boolean writeStartReleaseOrigin(BufferedWriter var1, ScmRepository var2, int var3) throws IOException;

    @Override
    public void leaveReleaseOrigin(ScmRepository releaseOrigin) {
        try {
            this.writeEndReleaseOrigin(this.writer(), releaseOrigin);
        }
        catch (Exception e) {
            this.close();
            throw new IllegalStateException("Failed to write release origin " + String.valueOf(releaseOrigin) + " to " + String.valueOf(this.reportFile), e);
        }
    }

    protected abstract void writeEndReleaseOrigin(BufferedWriter var1, ScmRepository var2) throws IOException;

    @Override
    public void visitProjectRelease(ProjectRelease release) {
        try {
            this.writeProjectRelease(this.writer(), release);
        }
        catch (Exception e) {
            this.close();
            throw new IllegalStateException("Failed to write release " + String.valueOf(release.id()) + " to " + String.valueOf(this.reportFile), e);
        }
    }

    protected abstract void writeProjectRelease(BufferedWriter var1, ProjectRelease var2) throws IOException;

    @Override
    public void leaveBom() {
        try {
            this.writeEndBom(this.writer());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to write conclusion to " + String.valueOf(this.reportFile), e);
        }
        finally {
            this.close();
        }
    }

    protected abstract void writeEndBom(BufferedWriter var1) throws IOException;
}

