/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Util {
    private static final String HTTPS_GITHUB_COM = "https://github.com/";

    public static Artifact pom(Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return artifact;
        }
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "", "pom", artifact.getVersion());
    }

    public static Model model(File pom) throws BomDecomposerException {
        Model model;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(pom));
        try {
            model = ModelUtils.readModel((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BomDecomposerException("Failed to parse POM " + String.valueOf(pom), e);
            }
        }
        ((InputStream)is).close();
        return model;
    }

    public static Artifact parentArtifact(Model model) {
        return model.getParent() == null ? null : new DefaultArtifact(model.getParent().getGroupId(), model.getParent().getArtifactId(), "", "pom", model.getParent().getVersion());
    }

    public static String getScmOrigin(Model model) {
        Scm scm = model.getScm();
        if (scm == null) {
            return null;
        }
        String url = Util.resolveModelValue(model, scm.getConnection());
        if (url != null && !url.isEmpty()) {
            return Util.scmToHttps(url);
        }
        url = Util.resolveModelValue(model, model.getUrl());
        if (url != null && url.startsWith(HTTPS_GITHUB_COM)) {
            return Util.scmToHttps(url);
        }
        url = Util.resolveModelValue(model, scm.getUrl());
        if (url != null && url.startsWith(HTTPS_GITHUB_COM)) {
            return Util.scmToHttps(url);
        }
        return null;
    }

    private static String scmToHttps(String s) {
        String tmp;
        String[] parts;
        s = ((String)s).replace("scm:", "");
        s = ((String)s).replace("git:", "");
        s = ((String)s).replace("git@", "");
        s = ((String)s).replace("ssh:", "");
        s = ((String)s).replace("svn:", "");
        if (((String)(s = ((String)s).replace(".git", ""))).startsWith("http://")) {
            s = ((String)s).replace("http://", "https://");
        } else if (!((String)s).startsWith("https://")) {
            s = ((String)(s = ((String)s).replace(':', '/'))).startsWith("//") ? "https:" + (String)s : (((String)s).charAt(0) == '/' ? "https:/" + (String)s : "https://" + (String)s);
        }
        if (((String)s).startsWith("https://github.com:")) {
            s = ((String)s).replace("https://github.com:", HTTPS_GITHUB_COM);
        }
        if (((String)s).startsWith(HTTPS_GITHUB_COM) && (parts = (tmp = ((String)s).substring(HTTPS_GITHUB_COM.length())).split("/")).length > 2) {
            s = HTTPS_GITHUB_COM + parts[0].replace(":", "") + "/" + parts[1];
        }
        return s;
    }

    public static String getScmTag(Model model) {
        return model.getScm() == null ? null : Util.resolveModelValue(model, model.getScm().getTag());
    }

    private static String resolveModelValue(Model model, String value) {
        return value == null ? null : (value.contains("${") ? Util.substituteProperties(value, model) : value);
    }

    private static String substituteProperties(String str, Model model) {
        Properties props = model.getProperties();
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            map.put(prop.getKey().toString(), prop.getValue().toString());
        }
        map.put("project.version", ModelUtils.getVersion((Model)model));
        return new StringSubstitutor(map).replace(str);
    }
}

