/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class BouncyCastleReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.bouncycastle")) {
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            Object version = releaseId.getValue();
            if (((String)version).startsWith("r") && ((String)version).contains("rv")) {
                return releaseId;
            }
            int i = ((String)version).indexOf(46);
            if (i < 0) {
                return releaseId;
            }
            version = "r" + ((String)version).substring(0, i) + "rv" + ((String)version).substring(i + 1);
            return ScmRevision.tag(releaseId.getRepository(), (String)version);
        }
        return null;
    }
}

