/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.diff;

import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.maven.dependency.ArtifactKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class BomDiff {
    private final Artifact mainBom;
    private final String mainSource;
    private final URL mainUrl;
    private final Artifact toBom;
    private final String toSource;
    private final URL toUrl;
    private final int mainSize;
    private final int toSize;
    private final List<Dependency> missing;
    private final List<Dependency> extra;
    private final List<Dependency> matching;
    private final List<VersionChange> upgraded;
    private final List<VersionChange> downgraded;

    public static Config config() {
        return new Config();
    }

    private BomDiff(Config config) {
        this.mainBom = config.mainBom;
        this.mainSource = config.mainSource;
        this.mainUrl = config.mainUrl;
        this.toBom = config.toBom;
        this.toSource = config.toSource;
        this.toUrl = config.toUrl;
        this.mainSize = config.mainDeps.size();
        this.toSize = config.toDeps.size();
        Map<ArtifactKey, Dependency> mainDeps = BomDiff.toMap(config.mainDeps);
        Map<ArtifactKey, Dependency> toDeps = BomDiff.toMap(config.toDeps);
        HashMap<String, Dependency> missing = new HashMap<String, Dependency>();
        HashMap extra = new HashMap();
        HashMap<String, Dependency> matching = new HashMap<String, Dependency>();
        HashMap<String, VersionChange> upgraded = new HashMap<String, VersionChange>();
        HashMap<String, VersionChange> downgraded = new HashMap<String, VersionChange>();
        for (Map.Entry<ArtifactKey, Dependency> main : mainDeps.entrySet()) {
            Dependency toDep = toDeps.remove(main.getKey());
            if (toDep == null) {
                missing.put(main.getKey().toString(), main.getValue());
                continue;
            }
            if (main.getValue().getArtifact().getVersion().equals(toDep.getArtifact().getVersion())) {
                matching.put(main.getKey().toString(), main.getValue());
                continue;
            }
            if (new DefaultArtifactVersion(main.getValue().getArtifact().getVersion()).compareTo((ArtifactVersion)new DefaultArtifactVersion(toDep.getArtifact().getVersion())) > 0) {
                downgraded.put(main.getKey().toString(), new VersionChange(main.getValue(), toDep, false));
                continue;
            }
            upgraded.put(main.getKey().toString(), new VersionChange(main.getValue(), toDep, true));
        }
        toDeps.entrySet().forEach(d -> extra.put(((ArtifactKey)d.getKey()).toString(), (Dependency)d.getValue()));
        this.missing = this.ordered(missing);
        this.extra = this.ordered(extra);
        this.matching = this.ordered(matching);
        this.upgraded = this.ordered(upgraded);
        this.downgraded = this.ordered(downgraded);
    }

    private <T> List<T> ordered(Map<String, T> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        ArrayList list = new ArrayList(map.size());
        keys.forEach(k -> list.add(map.get(k)));
        return list;
    }

    public Artifact mainBom() {
        return this.mainBom;
    }

    public String mainSource() {
        return this.mainSource;
    }

    public URL mainUrl() {
        return this.mainUrl;
    }

    public Artifact toBom() {
        return this.toBom;
    }

    public String toSource() {
        return this.toSource;
    }

    public URL toUrl() {
        return this.toUrl;
    }

    public int mainBomSize() {
        return this.mainSize;
    }

    public int toBomSize() {
        return this.toSize;
    }

    public boolean hasMissing() {
        return !this.missing.isEmpty();
    }

    public List<Dependency> missing() {
        return this.missing;
    }

    public boolean hasExtra() {
        return !this.extra.isEmpty();
    }

    public List<Dependency> extra() {
        return this.extra;
    }

    public boolean hasMatching() {
        return !this.matching.isEmpty();
    }

    public List<Dependency> matching() {
        return this.matching;
    }

    public boolean hasUpgraded() {
        return !this.upgraded.isEmpty();
    }

    public List<VersionChange> upgraded() {
        return this.upgraded;
    }

    public boolean hasDowngraded() {
        return !this.downgraded.isEmpty();
    }

    public List<VersionChange> downgraded() {
        return this.downgraded;
    }

    private static Map<ArtifactKey, Dependency> toMap(List<Dependency> deps) {
        HashMap<ArtifactKey, Dependency> map = new HashMap<ArtifactKey, Dependency>(deps.size());
        deps.forEach(d -> map.put(BomDiff.key(d), (Dependency)d));
        return map;
    }

    private static ArtifactKey key(Dependency dep) {
        return ArtifactKey.of((String)dep.getArtifact().getGroupId(), (String)dep.getArtifact().getArtifactId(), (String)dep.getArtifact().getClassifier(), (String)dep.getArtifact().getExtension());
    }

    public static class Config {
        private Artifact mainBom;
        private String mainSource;
        private URL mainUrl;
        private Artifact toBom;
        private String toSource;
        private URL toUrl;
        private List<Dependency> mainDeps;
        private List<Dependency> toDeps;
        private ArtifactResolver resolver;

        private Config() {
        }

        public Config resolver(ArtifactResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Config compare(Artifact bomArtifact) {
            ArtifactResolver resolver = this.defaultResolver();
            ArtifactDescriptorResult descr = resolver.describe(bomArtifact);
            this.mainBom = descr.getArtifact();
            this.mainSource = bomArtifact.toString();
            this.mainUrl = this.toUrl(resolver.resolve(bomArtifact).getArtifact().getFile().toPath());
            this.mainDeps = descr.getManagedDependencies();
            return this;
        }

        public Config compare(Path bomPath) {
            ArtifactDescriptorResult descr = this.descriptor(bomPath);
            this.mainBom = descr.getArtifact();
            this.mainSource = bomPath.toString();
            this.mainUrl = this.toUrl(bomPath);
            this.mainDeps = descr.getManagedDependencies();
            return this;
        }

        public BomDiff to(String groupId, String artifactId, String version) {
            return this.to((Artifact)new DefaultArtifact(groupId, artifactId, null, "pom", version));
        }

        public BomDiff to(Artifact bomArtifact) {
            ArtifactResolver resolver = this.defaultResolver();
            ArtifactDescriptorResult descr = resolver.describe(bomArtifact);
            this.toBom = descr.getArtifact();
            this.toSource = bomArtifact.toString();
            this.toUrl = this.toUrl(resolver.resolve(bomArtifact).getArtifact().getFile().toPath());
            this.toDeps = descr.getManagedDependencies();
            return this.diff();
        }

        public BomDiff to(Path bomPath) {
            ArtifactDescriptorResult descr = this.descriptor(bomPath);
            this.toBom = descr.getArtifact();
            this.toSource = bomPath.toString();
            this.toUrl = this.toUrl(bomPath);
            this.toDeps = descr.getManagedDependencies();
            return this.diff();
        }

        private ArtifactDescriptorResult descriptor(Path pom) {
            MavenArtifactResolver underlyingResolver;
            MavenArtifactResolver.Builder resolverBuilder = (MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setCurrentProject(pom.normalize().toAbsolutePath().toString());
            if (this.resolver != null) {
                MavenArtifactResolver baseResolver = this.resolver.underlyingResolver();
                ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)resolverBuilder.setRepositorySystem(baseResolver.getSystem())).setRemoteRepositoryManager(baseResolver.getRemoteRepositoryManager())).setSettingsDecrypter(baseResolver.getMavenContext().getSettingsDecrypter());
            }
            try {
                underlyingResolver = resolverBuilder.build();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver for " + String.valueOf(pom), e);
            }
            BootstrapMavenContext mvnCtx = underlyingResolver.getMavenContext();
            LocalProject bomProject = mvnCtx.getCurrentProject();
            DefaultArtifact pomArtifact = new DefaultArtifact(bomProject.getGroupId(), bomProject.getArtifactId(), "", "pom", bomProject.getVersion());
            pomArtifact = pomArtifact.setFile(pom.toFile());
            return ArtifactResolverProvider.get(underlyingResolver, this.resolver.getBaseDir()).describe((Artifact)pomArtifact);
        }

        private ArtifactResolver defaultResolver() {
            return this.resolver == null ? (this.resolver = ArtifactResolverProvider.get()) : this.resolver;
        }

        private URL toUrl(Path p) {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to translate " + String.valueOf(p) + " to URL", e);
            }
        }

        private BomDiff diff() {
            return new BomDiff(this);
        }
    }

    public static class VersionChange {
        private boolean upgrade;
        private final Dependency from;
        private final Dependency to;

        private VersionChange(Dependency from, Dependency to, boolean upgrade) {
            this.from = from;
            this.to = to;
            this.upgrade = upgrade;
        }

        public Dependency from() {
            return this.from;
        }

        public Dependency to() {
            return this.to;
        }

        public boolean upgrade() {
            return this.upgrade;
        }
    }
}

