/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Util {
    public static Artifact pom(Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return artifact;
        }
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "", "pom", artifact.getVersion());
    }

    public static Model model(File pom) throws BomDecomposerException {
        Model model;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(pom));
        try {
            model = ModelUtils.readModel((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BomDecomposerException("Failed to parse POM " + pom, e);
            }
        }
        ((InputStream)is).close();
        return model;
    }

    public static Artifact parentArtifact(Model model) {
        return model.getParent() == null ? null : new DefaultArtifact(model.getParent().getGroupId(), model.getParent().getArtifactId(), "", "pom", model.getParent().getVersion());
    }

    public static String getScmOrigin(Model model) {
        Scm scm = model.getScm();
        if (scm == null) {
            return null;
        }
        if (scm.getConnection() != null) {
            return Util.resolveModelValue(model, scm.getConnection());
        }
        String url = Util.resolveModelValue(model, model.getUrl());
        if (url != null && url.startsWith("https://github.com/")) {
            return url;
        }
        return null;
    }

    public static String getScmTag(Model model) {
        return model.getScm() == null ? null : Util.resolveModelValue(model, model.getScm().getTag());
    }

    private static String resolveModelValue(Model model, String value) {
        return value == null ? null : (value.contains("${") ? Util.substituteProperties(value, model) : value);
    }

    private static String substituteProperties(String str, Model model) {
        Properties props = model.getProperties();
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            map.put(prop.getKey().toString(), prop.getValue().toString());
        }
        map.put("project.version", ModelUtils.getVersion((Model)model));
        return new StringSubstitutor(map).replace(str);
    }
}

