/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DefaultDecomposedBomBuilder;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.UpdateAvailabilityTransformer;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bom.resolver.ArtifactNotFoundException;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class BomDecomposer {
    private MessageWriter logger;
    private boolean debug;
    private Artifact bomArtifact;
    private PomResolver bomSource;
    private Iterable<Dependency> artifacts;
    private ArtifactResolver mvnResolver;
    private ProjectModelResolver modelResolver;
    private List<ReleaseIdDetector> releaseDetectors = new ArrayList<ReleaseIdDetector>();
    private DecomposedBomBuilder decomposedBuilder;
    private DecomposedBomTransformer transformer;

    public static BomDecomposerConfig config() {
        return new BomDecomposer().new BomDecomposerConfig();
    }

    private BomDecomposer() {
    }

    private ArtifactResolver artifactResolver() {
        try {
            return this.mvnResolver == null ? (this.mvnResolver = ArtifactResolverProvider.get(((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(this.debug)).build())) : this.mvnResolver;
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
        }
    }

    private DecomposedBom decompose() throws BomDecomposerException {
        DecomposedBomBuilder bomBuilder = this.decomposedBuilder == null ? new DefaultDecomposedBomBuilder() : this.decomposedBuilder;
        bomBuilder.bomArtifact(this.bomArtifact);
        Iterable<Dependency> artifacts = this.artifacts == null ? this.bomManagedDeps() : this.artifacts;
        for (Dependency dep : artifacts) {
            try {
                String classifier = dep.getArtifact().getClassifier();
                if (!(classifier.isEmpty() || classifier.equals("sources") || classifier.equals("javadoc"))) {
                    this.resolve(dep.getArtifact());
                }
                bomBuilder.bomDependency(this.releaseId(dep.getArtifact()), dep);
            }
            catch (BomDecomposerException e) {
                throw e;
            }
            catch (ArtifactNotFoundException | UnresolvableModelException e) {
                this.logger().debug("Failed to resolve POM for %s", new Object[]{dep});
            }
        }
        return this.transformer == null ? bomBuilder.build() : this.transformer.transform(bomBuilder.build());
    }

    private Iterable<Dependency> bomManagedDeps() throws BomDecomposerException {
        return this.describe(this.bomArtifact).getManagedDependencies();
    }

    private ReleaseId releaseId(Artifact artifact) throws BomDecomposerException, UnresolvableModelException {
        Model tmp;
        Model effectiveModel;
        for (ReleaseIdDetector releaseDetector : this.releaseDetectors) {
            ReleaseId releaseId = releaseDetector.detectReleaseId(this, artifact);
            if (releaseId == null) continue;
            return releaseId;
        }
        ModelSource ms = this.modelResolver.resolveModel(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        try (InputStream is = ms.getInputStream();){
            effectiveModel = ModelUtils.readModel((InputStream)is);
        }
        catch (IOException e) {
            throw new BomDecomposerException("Failed to read model from " + ms.getLocation(), e);
        }
        if (effectiveModel.getScm() != null) {
            return ReleaseIdFactory.forModel(effectiveModel);
        }
        Model model = this.model(artifact);
        while ((tmp = this.workspaceParent(model)) != null) {
            model = tmp;
        }
        return ReleaseIdFactory.forModel(model);
    }

    private Model workspaceParent(Model model) throws BomDecomposerException {
        if (model.getParent() == null) {
            return null;
        }
        Model parentModel = this.model(Util.parentArtifact(model));
        if (Util.getScmOrigin(model) != null) {
            return Util.getScmOrigin(model).equals(Util.getScmOrigin(parentModel)) && Util.getScmTag(model).equals(Util.getScmTag(parentModel)) ? parentModel : null;
        }
        if (model.getParent().getRelativePath().isEmpty()) {
            return null;
        }
        if (model.getVersion() == null || model.getParent().getRelativePath() != null && model.getParent().getRelativePath().startsWith("..") || ModelUtils.getGroupId((Model)parentModel).equals(ModelUtils.getGroupId((Model)model)) && ModelUtils.getVersion((Model)parentModel).equals(ModelUtils.getVersion((Model)model))) {
            return parentModel;
        }
        if (parentModel.getModules().isEmpty()) {
            return null;
        }
        for (String path : parentModel.getModules()) {
            String dirName = Paths.get(path, new String[0]).getFileName().toString();
            if (!model.getArtifactId().contains(dirName)) continue;
            return parentModel;
        }
        return null;
    }

    public MessageWriter logger() {
        return this.logger == null ? (this.logger = MessageWriter.debug()) : this.logger;
    }

    public Model model(Artifact artifact) throws BomDecomposerException {
        return Util.model(this.resolve(Util.pom(artifact)).getFile());
    }

    private ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        return this.artifactResolver().describe(artifact);
    }

    private Artifact resolve(Artifact artifact) throws BomDecomposerException {
        return this.artifactResolver().resolve(artifact).getArtifact();
    }

    public class BomDecomposerConfig {
        boolean loadReleaseDetectors = true;

        private BomDecomposerConfig() {
        }

        public BomDecomposerConfig logger(MessageWriter messageWriter) {
            BomDecomposer.this.logger = messageWriter;
            return this;
        }

        public BomDecomposerConfig debug() {
            BomDecomposer.this.debug = true;
            return this;
        }

        public BomDecomposerConfig mavenArtifactResolver(ArtifactResolver resolver) {
            BomDecomposer.this.mvnResolver = resolver;
            if (resolver != null) {
                MavenArtifactResolver mvn = resolver.underlyingResolver();
                BomDecomposer.this.modelResolver = new ProjectModelResolver(mvn.getSession(), new RequestTrace(null), mvn.getSystem(), mvn.getRemoteRepositoryManager(), mvn.getRepositories(), ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null);
            }
            return this;
        }

        public BomDecomposerConfig bomFile(Path bom) {
            MavenArtifactResolver underlyingResolver;
            MavenArtifactResolver.Builder resolverBuilder = (MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setCurrentProject(bom.normalize().toAbsolutePath().toString());
            if (BomDecomposer.this.mvnResolver != null) {
                MavenArtifactResolver baseResolver = BomDecomposer.this.mvnResolver.underlyingResolver();
                ((MavenArtifactResolver.Builder)resolverBuilder.setRepositorySystem(baseResolver.getSystem())).setRemoteRepositoryManager(baseResolver.getRemoteRepositoryManager());
            }
            try {
                underlyingResolver = resolverBuilder.build();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver for " + bom, e);
            }
            this.mavenArtifactResolver(ArtifactResolverProvider.get(underlyingResolver, BomDecomposer.this.mvnResolver == null ? null : BomDecomposer.this.mvnResolver.getBaseDir()));
            BootstrapMavenContext mvnCtx = underlyingResolver.getMavenContext();
            LocalProject bomProject = mvnCtx.getCurrentProject();
            BomDecomposer.this.bomArtifact = new DefaultArtifact(bomProject.getGroupId(), bomProject.getArtifactId(), "", "pom", bomProject.getVersion());
            BomDecomposer.this.bomArtifact = BomDecomposer.this.bomArtifact.setFile(bom.toFile());
            BomDecomposer.this.bomSource = PomSource.of(bom);
            return this;
        }

        public BomDecomposerConfig bomArtifact(String groupId, String artifactId, String version) {
            return this.bomArtifact((Artifact)new DefaultArtifact(groupId, artifactId, "", "pom", version));
        }

        public BomDecomposerConfig bomArtifact(Artifact artifact) {
            BomDecomposer.this.bomArtifact = artifact;
            BomDecomposer.this.bomSource = PomSource.of(artifact);
            return this;
        }

        public BomDecomposerConfig addReleaseDetector(ReleaseIdDetector releaseDetector) {
            BomDecomposer.this.releaseDetectors.add(releaseDetector);
            return this;
        }

        public BomDecomposerConfig checkForUpdates() {
            return this.transform(new UpdateAvailabilityTransformer(BomDecomposer.this.mvnResolver, BomDecomposer.this.logger));
        }

        public BomDecomposerConfig transform(DecomposedBomTransformer bomTransformer) {
            BomDecomposer.this.transformer = bomTransformer;
            return this;
        }

        public BomDecomposerConfig dependencies(Iterable<Dependency> iterator) {
            BomDecomposer.this.artifacts = iterator;
            return this;
        }

        public BomDecomposerConfig loadReleaseDetectors(boolean loadReleaseDetectors) {
            this.loadReleaseDetectors = loadReleaseDetectors;
            return this;
        }

        public DecomposedBom decompose() throws BomDecomposerException {
            if (this.loadReleaseDetectors) {
                ServiceLoader.load(ReleaseIdDetector.class, Thread.currentThread().getContextClassLoader()).forEach(d -> {
                    BomDecomposer.this.logger().debug("Loaded release detector " + d);
                    BomDecomposer.this.releaseDetectors.add((ReleaseIdDetector)d);
                });
            }
            return BomDecomposer.this.decompose();
        }
    }
}

