/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.eclipse.aether.artifact.Artifact;

public class ReleaseIdResolver {
    private final ArtifactResolver resolver;
    private Collection<ReleaseIdDetector> releaseDetectors;

    public ReleaseIdResolver(MavenArtifactResolver resolver) {
        this(ArtifactResolverProvider.get(resolver));
    }

    public ReleaseIdResolver(ArtifactResolver resolver) {
        this(resolver, List.of());
    }

    public ReleaseIdResolver(ArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors) {
        this.resolver = Objects.requireNonNull(resolver);
        this.releaseDetectors = releaseDetectors;
    }

    public ReleaseId releaseId(Artifact artifact) throws BomDecomposerException, UnresolvableModelException {
        Model tmp;
        for (ReleaseIdDetector releaseDetector : this.releaseDetectors) {
            ReleaseId releaseId = releaseDetector.detectReleaseId(this, artifact);
            if (releaseId == null) continue;
            return releaseId;
        }
        Model model = this.model(artifact);
        while ((tmp = this.workspaceParent(model)) != null) {
            model = tmp;
        }
        return ReleaseIdFactory.forModel(model);
    }

    private Model workspaceParent(Model model) throws BomDecomposerException {
        if (model.getParent() == null) {
            return null;
        }
        Model parentModel = this.model(Util.parentArtifact(model));
        if (Util.getScmOrigin(model) != null) {
            return Util.getScmOrigin(model).equals(Util.getScmOrigin(parentModel)) && Util.getScmTag(model).equals(Util.getScmTag(parentModel)) ? parentModel : null;
        }
        if (model.getParent().getRelativePath().isEmpty()) {
            return null;
        }
        if (model.getVersion() == null || model.getParent().getRelativePath() != null && !model.getParent().getRelativePath().startsWith("../pom.xml") || ModelUtils.getGroupId((Model)parentModel).equals(ModelUtils.getGroupId((Model)model)) && ModelUtils.getVersion((Model)parentModel).equals(ModelUtils.getVersion((Model)model))) {
            return parentModel;
        }
        if (parentModel.getModules().isEmpty()) {
            return null;
        }
        for (String path : parentModel.getModules()) {
            String dirName = Paths.get(path, new String[0]).getFileName().toString();
            if (!model.getArtifactId().contains(dirName)) continue;
            return parentModel;
        }
        return null;
    }

    public Model model(Artifact artifact) throws BomDecomposerException {
        return Util.model(this.resolve(Util.pom(artifact)).getFile());
    }

    private Artifact resolve(Artifact artifact) throws BomDecomposerException {
        return this.resolver.resolve(artifact).getArtifact();
    }
}

