/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import java.util.Objects;

public interface ReleaseOrigin
extends Comparable<ReleaseOrigin> {

    public static class GaOrigin
    implements ReleaseOrigin {
        final String groupId;
        final String artifactId;

        GaOrigin(String groupId, String artifactId) {
            this.groupId = Objects.requireNonNull(groupId);
            this.artifactId = Objects.requireNonNull(artifactId);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GaOrigin other = (GaOrigin)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }

        @Override
        public int compareTo(ReleaseOrigin o) {
            return this.toString().compareTo(o.toString());
        }
    }

    public static class ScmConnectionOrigin
    implements ReleaseOrigin {
        final String connection;

        ScmConnectionOrigin(String connection) {
            this.connection = Objects.requireNonNull(connection);
        }

        public String toString() {
            return this.connection;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScmConnectionOrigin other = (ScmConnectionOrigin)obj;
            return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
        }

        @Override
        public int compareTo(ReleaseOrigin o) {
            return this.toString().compareTo(o.toString());
        }
    }

    public static class Factory {
        public static ReleaseOrigin scmConnection(String connection) {
            return new ScmConnectionOrigin(connection);
        }

        public static ReleaseOrigin ga(String groupId, String artifactId) {
            return new GaOrigin(groupId, artifactId);
        }
    }
}

