/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class DefaultDecomposedBomBuilder
implements DecomposedBomBuilder {
    private PomResolver bomSource;
    private Artifact bomArtifact;
    private Map<ReleaseId, ProjectRelease.Builder> releases = new HashMap<ReleaseId, ProjectRelease.Builder>();

    @Override
    public void bomSource(PomResolver bomSource) {
        this.bomSource = bomSource;
    }

    @Override
    public void bomArtifact(Artifact bomArtifact) {
        this.bomArtifact = bomArtifact;
    }

    @Override
    public void bomDependency(ReleaseId releaseId, Dependency artifact) throws BomDecomposerException {
        this.releases.computeIfAbsent(releaseId, t -> ProjectRelease.builder(t)).add(artifact);
    }

    @Override
    public DecomposedBom build() throws BomDecomposerException {
        DecomposedBom.Builder bomBuilder = DecomposedBom.builder();
        bomBuilder.bomArtifact(this.bomArtifact);
        bomBuilder.bomSource(this.bomSource);
        for (ProjectRelease.Builder builder : this.releases.values()) {
            bomBuilder.addRelease(builder.build());
        }
        return bomBuilder.build();
    }
}

