/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ReleaseIdResolver {
    private final MessageWriter log;
    private final ArtifactResolver resolver;
    private final Collection<ReleaseIdDetector> releaseDetectors;
    private final boolean validateRepoTag;
    private final Map<ArtifactCoords, String> versionMapping;
    private Set<ReleaseId> validatedReleaseIds;
    private HttpClient httpClient;

    public ReleaseIdResolver(MavenArtifactResolver resolver) {
        this(ArtifactResolverProvider.get(resolver));
    }

    public ReleaseIdResolver(MavenArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors) {
        this(ArtifactResolverProvider.get(resolver), releaseDetectors);
    }

    public ReleaseIdResolver(MavenArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors, MessageWriter log, boolean validateRepoTag, Map<ArtifactCoords, String> versionMapping) {
        this(ArtifactResolverProvider.get(resolver), releaseDetectors, log, validateRepoTag, versionMapping);
    }

    public ReleaseIdResolver(ArtifactResolver resolver) {
        this(resolver, List.of());
    }

    public ReleaseIdResolver(ArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors) {
        this.resolver = Objects.requireNonNull(resolver);
        this.releaseDetectors = releaseDetectors;
        this.validateRepoTag = false;
        this.log = MessageWriter.info();
        this.versionMapping = Map.of();
    }

    public ReleaseIdResolver(ArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors, MessageWriter log, boolean validateRepoTag, Map<ArtifactCoords, String> versionMapping) {
        this.resolver = Objects.requireNonNull(resolver);
        this.releaseDetectors = releaseDetectors;
        this.validateRepoTag = validateRepoTag;
        this.log = log;
        this.versionMapping = versionMapping;
    }

    private Artifact getTargetArtifact(Artifact artifact) {
        if (this.versionMapping.isEmpty()) {
            return artifact;
        }
        String v = this.versionMapping.get(ArtifactCoords.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getExtension(), (String)artifact.getVersion()));
        if (v == null) {
            return artifact;
        }
        return artifact.setVersion(v);
    }

    public ReleaseId releaseId(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException, UnresolvableModelException {
        artifact = this.getTargetArtifact(artifact);
        for (ReleaseIdDetector releaseDetector : this.releaseDetectors) {
            ReleaseId releaseId = releaseDetector.detectReleaseId(this, artifact);
            if (releaseId == null) continue;
            return this.validateRepoTag ? this.validateTag(releaseId) : releaseId;
        }
        return this.validateRepoTag ? this.validateTag(this.defaultReleaseId(artifact, repos)) : this.defaultReleaseId(artifact, repos);
    }

    public ReleaseId defaultReleaseId(Artifact artifact) throws BomDecomposerException {
        return this.defaultReleaseId(artifact, List.of());
    }

    public ReleaseId defaultReleaseId(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException {
        Model tmp;
        Model model = this.model(artifact, repos);
        while (!ReleaseIdResolver.hasScmInfo(model) && (tmp = this.workspaceParent(model, repos)) != null) {
            model = tmp;
        }
        return ReleaseIdFactory.forModel(model);
    }

    public ReleaseId validateTag(ReleaseId releaseId) {
        if (this.validatedReleaseIds == null) {
            this.validatedReleaseIds = new HashSet<ReleaseId>();
        }
        if (!this.validatedReleaseIds.add(releaseId)) {
            return releaseId;
        }
        Object repoUrl = releaseId.origin().toString();
        if (!((String)repoUrl).startsWith("https:") && !((String)repoUrl).startsWith("http:")) {
            this.log.warn("Non-HTTP(s) origin " + (String)repoUrl);
            return releaseId;
        }
        if (((String)repoUrl).charAt(((String)repoUrl).length() - 1) != '/') {
            repoUrl = (String)repoUrl + "/";
        }
        if (((String)repoUrl).contains("github.com")) {
            repoUrl = (String)repoUrl + "releases/tag/";
        } else if (((String)repoUrl).contains("gitlab.com")) {
            repoUrl = (String)repoUrl + "-/tags/";
        }
        repoUrl = (String)repoUrl + releaseId.version().asString();
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newHttpClient();
        }
        try {
            Object tagUrl = repoUrl;
            this.httpClient.send(HttpRequest.newBuilder().GET().uri(URI.create((String)repoUrl)).timeout(Duration.ofSeconds(5L)).build(), arg_0 -> this.lambda$validateTag$0((String)tagUrl, arg_0));
        }
        catch (Exception e) {
            this.log.warn("Invalid release tag " + (String)repoUrl);
        }
        return releaseId;
    }

    private static boolean hasScmInfo(Model model) {
        return Util.getScmOrigin(model) != null;
    }

    private Model workspaceParent(Model model, List<RemoteRepository> repos) throws BomDecomposerException {
        if (model.getParent() == null) {
            return null;
        }
        Model parentModel = this.model(Util.parentArtifact(model), repos);
        if (Util.getScmOrigin(model) != null) {
            return Util.getScmOrigin(model).equals(Util.getScmOrigin(parentModel)) && Util.getScmTag(model).equals(Util.getScmTag(parentModel)) ? parentModel : null;
        }
        if (model.getParent().getRelativePath().isEmpty()) {
            return null;
        }
        if (model.getVersion() == null || model.getParent().getRelativePath() != null && !model.getParent().getRelativePath().startsWith("../pom.xml") || ModelUtils.getGroupId((Model)parentModel).equals(ModelUtils.getGroupId((Model)model)) && ModelUtils.getVersion((Model)parentModel).equals(ModelUtils.getVersion((Model)model))) {
            return parentModel;
        }
        if (parentModel.getModules().isEmpty()) {
            return null;
        }
        for (String path : parentModel.getModules()) {
            String dirName = Paths.get(path, new String[0]).getFileName().toString();
            if (!model.getArtifactId().contains(dirName)) continue;
            return parentModel;
        }
        return null;
    }

    public Model model(Artifact artifact) throws BomDecomposerException {
        return Util.model(this.resolver.resolve(Util.pom(artifact)).getArtifact().getFile());
    }

    public Model model(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException {
        return Util.model(this.resolver.resolve(Util.pom(artifact), repos).getArtifact().getFile());
    }

    private /* synthetic */ HttpResponse.BodySubscriber lambda$validateTag$0(String tagUrl, HttpResponse.ResponseInfo r) {
        switch (r.statusCode()) {
            case 200: 
            case 429: {
                break;
            }
            default: {
                this.log.warn("Got " + r.statusCode() + " response code validating " + tagUrl);
            }
        }
        return HttpResponse.BodySubscribers.discarding();
    }
}

