/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import org.eclipse.aether.artifact.Artifact;

public class ApacheHttpComponentsReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (!artifact.getGroupId().equals("org.apache.httpcomponents")) {
            return null;
        }
        ReleaseId releaseId = releaseResolver.defaultReleaseId(artifact);
        String origin = releaseId.origin().toString();
        int i = origin.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        String repoName = origin.substring(i + 1);
        Object version = artifact.getVersion();
        version = repoName.equals("httpcomponents-parent") && ((String)version).equals("11") ? (String)version + "-RC1" : "rel/v" + (String)version;
        return ReleaseIdFactory.forScmAndTag("https://github.com/apache/" + repoName, (String)version);
    }
}

