/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class DefaultDecomposedBomBuilder
implements DecomposedBomBuilder {
    private PomResolver bomSource;
    private Artifact bomArtifact;
    private Map<ReleaseId, List<ProjectDependency>> releases = new HashMap<ReleaseId, List<ProjectDependency>>();

    @Override
    public void bomSource(PomResolver bomSource) {
        this.bomSource = bomSource;
    }

    @Override
    public void bomArtifact(Artifact bomArtifact) {
        this.bomArtifact = bomArtifact;
    }

    @Override
    public void bomDependency(ReleaseId releaseId, Dependency artifact) throws BomDecomposerException {
        this.releases.computeIfAbsent(releaseId, t -> new ArrayList()).add(ProjectDependency.create(releaseId, artifact));
    }

    @Override
    public DecomposedBom build() throws BomDecomposerException {
        DecomposedBom.Builder bomBuilder = DecomposedBom.builder();
        bomBuilder.bomArtifact(this.bomArtifact);
        bomBuilder.bomSource(this.bomSource);
        for (Map.Entry<ReleaseId, List<ProjectDependency>> entry : this.releases.entrySet()) {
            bomBuilder.addRelease(ProjectRelease.create(entry.getKey(), entry.getValue()));
        }
        return bomBuilder.build();
    }
}

