/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bootstrap.model.AppArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class ProjectRelease {
    protected final ReleaseId id;
    protected List<ProjectDependency> deps;
    protected final Set<String> artifactVersions = new HashSet<String>();

    public static Builder builder(ReleaseId id) {
        return new ProjectRelease(id).new Builder();
    }

    public static ProjectRelease create(ReleaseId id, List<ProjectDependency> deps) {
        return new ProjectRelease(id, deps);
    }

    private ProjectRelease(ReleaseId id) {
        this(id, null);
    }

    private ProjectRelease(ReleaseId id, List<ProjectDependency> deps) {
        this.id = id;
        if (deps == null) {
            this.deps = new ArrayList<ProjectDependency>();
        } else {
            this.deps = deps;
            for (ProjectDependency dep : deps) {
                this.artifactVersions.add(dep.artifact().getVersion());
            }
        }
    }

    public ReleaseId id() {
        return this.id;
    }

    public List<ProjectDependency> dependencies() {
        return this.deps;
    }

    public Collection<String> artifactVersions() {
        return this.artifactVersions;
    }

    public class Builder {
        private LinkedHashMap<AppArtifactKey, ProjectDependency> deps = new LinkedHashMap();

        private Builder() {
        }

        public ReleaseId id() {
            return ProjectRelease.this.id;
        }

        public Builder add(ProjectDependency dep) {
            ProjectDependency existing = this.deps.put(dep.key(), dep);
            if (existing == null) {
                ProjectRelease.this.artifactVersions.add(dep.artifact().getVersion());
            } else if (!dep.artifact().getVersion().equals(existing.artifact().getVersion())) {
                throw new IllegalArgumentException("Failed to add " + dep + " since the release already includes " + existing);
            }
            return this;
        }

        public boolean includes(AppArtifactKey key) {
            return this.deps.containsKey(key);
        }

        public ProjectRelease build() {
            ProjectRelease.this.deps = new ArrayList<ProjectDependency>(this.deps.values());
            return ProjectRelease.this;
        }
    }
}

