/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.NoopDecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public class UpdateAvailabilityTransformer
implements DecomposedBomTransformer {
    @Override
    public DecomposedBom transform(final BomDecomposer decomposer, DecomposedBom decomposedBom) throws BomDecomposerException {
        Object[] params = new Object[]{decomposedBom.bomArtifact()};
        decomposer.logger().debug("Transforming decomposed %s", params);
        decomposedBom.visit(new NoopDecomposedBomVisitor(true){
            List<ProjectRelease> releases;
            {
                super(skipOriginsWithSingleRelease);
                this.releases = new ArrayList<ProjectRelease>();
            }

            @Override
            public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
                ArrayList<DefaultArtifactVersion> releaseVersions = new ArrayList<DefaultArtifactVersion>();
                HashMap<DefaultArtifactVersion, ReleaseId> versionToReleaseId = new HashMap<DefaultArtifactVersion, ReleaseId>();
                for (ProjectRelease release : this.releases) {
                    for (String versionStr : release.artifactVersions) {
                        DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                        releaseVersions.add(version);
                        ReleaseId prevReleaseId = versionToReleaseId.put(version, release.id());
                        if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.version().asString()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString())) <= 0) continue;
                        versionToReleaseId.put(version, prevReleaseId);
                    }
                }
                Collections.sort(releaseVersions);
                for (ProjectRelease release : this.releases) {
                    for (ProjectDependency dep : release.dependencies()) {
                        int i = releaseVersions.size() - 1;
                        if (release.id().equals(versionToReleaseId.get(releaseVersions.get(i)))) {
                            dep.preferredVersion = true;
                            continue;
                        }
                        while (i >= 0) {
                            ArtifactVersion version = (ArtifactVersion)releaseVersions.get(i--);
                            ReleaseId releaseId = (ReleaseId)versionToReleaseId.get(version);
                            if (release.id().equals(releaseId)) break;
                            Artifact updatedArtifact = dep.artifact().setVersion(version.toString());
                            if (!UpdateAvailabilityTransformer.this.isAvailable(decomposer, updatedArtifact)) continue;
                            dep.setAvailableUpdate(ProjectDependency.create(releaseId, dep.dependency().setArtifact(updatedArtifact)));
                            break;
                        }
                        if (dep.updateStatus() != ProjectDependency.UpdateStatus.UNKNOWN) continue;
                        dep.setUpdateUnavailable();
                    }
                }
                this.releases.clear();
            }

            @Override
            public void visitProjectRelease(ProjectRelease release) {
                this.releases.add(release);
            }
        });
        Object[] params1 = new Object[]{decomposedBom.bomArtifact()};
        decomposer.logger().debug("Transformed decomposed BOM %s", params1);
        return decomposedBom;
    }

    private boolean isAvailable(BomDecomposer decomposer, Artifact artifact) {
        try {
            decomposer.resolve(artifact);
            return true;
        }
        catch (BomDecomposerException e) {
            return false;
        }
    }
}

