/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.diff;

import io.quarkus.bom.decomposer.FileReportWriter;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.BomDiffReportGenerator;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class HtmlBomDiffReportGenerator
extends FileReportWriter
implements BomDiffReportGenerator {
    private static final String[] listBackground = new String[]{"background-color:#EBF4FA", "background-color:#FFFFFF"};
    private NumberFormat numberFormat;

    public static Config config(String name) {
        return new HtmlBomDiffReportGenerator(name).new Config();
    }

    public static Config config(Path reportFile) {
        return new HtmlBomDiffReportGenerator(reportFile).new Config();
    }

    private HtmlBomDiffReportGenerator(String name) {
        super(name);
    }

    private HtmlBomDiffReportGenerator(Path path) {
        super(path);
    }

    @Override
    public void report(BomDiff bomDiff) {
        try {
            this.generateHtml(bomDiff);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate HTML report", e);
        }
        finally {
            this.close();
        }
    }

    protected void generateHtml(BomDiff bomDiff) throws IOException {
        this.writeLine("<!DOCTYPE html>");
        this.openTag("html");
        this.openTag("head");
        this.offsetLine("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
        this.openTag("style");
        this.writeLine(".accordion {\n  background-color: #eee;\n  color: #444;\n  cursor: pointer;\n  padding: 18px;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 15px;\n  transition: 0.4s;\n}");
        this.writeLine(".active, .accordion:hover {\n  background-color: #ccc; \n}");
        this.writeLine(".panel {\n  padding: 0 18px;\n  display: none;\n  background-color: white;\n  overflow: hidden;\n}");
        this.closeTag("style");
        this.closeTag("head");
        this.openTag("body");
        this.writeTag("h1", "Managed Dependencies Comparison Report");
        this.generateBody(bomDiff);
        this.openTag("script");
        this.writeLine("var acc = document.getElementsByClassName(\"accordion\");\nvar i;\nfor (i = 0; i < acc.length; i++) {\n  acc[i].addEventListener(\"click\", function() {\n    this.classList.toggle(\"active\");\n    var panel = this.nextElementSibling;\n    if (panel.style.display === \"block\") {\n      panel.style.display = \"none\";\n    } else {\n      panel.style.display = \"block\";\n    }\n  });\n}");
        this.closeTag("script");
        this.closeTag("body");
        this.closeTag("html");
    }

    private void generateBody(BomDiff bomDiff) throws IOException {
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "BOM");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "groupId:");
        this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getGroupId());
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "artifactId:");
        this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getArtifactId());
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "version:");
        this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getVersion());
        this.closeTag("tr");
        if (!bomDiff.mainBom().toString().equals(bomDiff.mainSource())) {
            this.openTag("tr");
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "source:");
            this.writeTag("td", "font-weight:bold", bomDiff.mainSource());
            this.closeTag("tr");
        }
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "managed dependencies:");
        this.writeTag("td", bomDiff.mainBomSize());
        this.closeTag("tr");
        this.closeTag("table");
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "compared to");
        if (!bomDiff.toBom().equals(bomDiff.mainBom())) {
            this.openTag("tr");
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "groupId:");
            this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getGroupId());
            this.closeTag("tr");
            this.openTag("tr");
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "artifactId:");
            this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getArtifactId());
            this.closeTag("tr");
            this.openTag("tr");
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "version:");
            this.writeTag("td", "font-weight:bold", bomDiff.mainBom().getVersion());
            this.closeTag("tr");
        }
        if (!bomDiff.toBom().toString().equals(bomDiff.toSource())) {
            this.openTag("tr");
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "source:");
            this.writeTag("td", "font-weight:bold", bomDiff.toSource());
            this.closeTag("tr");
        }
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "managed dependencies:");
        this.writeTag("td", bomDiff.toBomSize());
        this.closeTag("tr");
        this.closeTag("table");
        if (bomDiff.hasDowngraded()) {
            this.versionChangeAccordion("Downgraded dependencies", bomDiff.mainBomSize(), bomDiff.downgraded());
        }
        if (bomDiff.hasUpgraded()) {
            this.versionChangeAccordion("Upgraded dependencies", bomDiff.mainBomSize(), bomDiff.upgraded());
        }
        if (bomDiff.hasMissing()) {
            this.depsListAccordion("Removed dependencies", bomDiff.mainBomSize(), bomDiff.missing(), true);
        }
        if (bomDiff.hasExtra()) {
            this.depsListAccordion("New dependencies", bomDiff.toBomSize(), bomDiff.extra(), false);
        }
        if (bomDiff.hasMatching()) {
            this.depsListAccordion("Matching dependencies", bomDiff.mainBomSize(), bomDiff.matching(), false);
        }
    }

    private void depsListAccordion(String caption, int total, List<Dependency> deps, boolean warn) throws IOException {
        this.accordionButton(caption, total, deps.size());
        this.offsetLine("<div class=\"panel\">");
        this.openTag("table");
        int i = 0;
        for (Dependency d : deps) {
            this.openTag("tr", listBackground[i ^= 1]);
            this.writeTag("td", this.gact(d.getArtifact()));
            this.writeTag("td", warn ? "color:red" : "color:green", d.getArtifact().getVersion());
            this.closeTag("tr");
        }
        this.closeTag("table");
        this.offsetLine("</div>");
    }

    private void versionChangeAccordion(String caption, int total, List<BomDiff.VersionChange> changes) throws IOException {
        this.accordionButton(caption, total, changes.size());
        this.offsetLine("<div class=\"panel\">");
        this.openTag("table");
        int i = 0;
        for (BomDiff.VersionChange d : changes) {
            this.openTag("tr", listBackground[i ^= 1]);
            this.writeTag("td", this.gact(d.from().getArtifact()));
            this.writeTag("td", d.from().getArtifact().getVersion());
            this.writeTag("td", d.upgrade() ? "color:green" : "color:red", "&#8702");
            this.writeTag("td", d.upgrade() ? "color:green" : "color:red", d.to().getArtifact().getVersion());
            this.closeTag("tr");
        }
        this.closeTag("table");
        this.offsetLine("</div>");
    }

    private void accordionButton(String caption, int whole, int part) throws IOException {
        this.offsetLine("<button class=\"accordion\">" + caption + ": " + part + " (" + this.percentage(part, whole) + "%)</button>");
    }

    private String gact(Artifact a) {
        StringBuilder buf = this.buf();
        buf.append(a.getGroupId()).append(':').append(a.getArtifactId());
        if (!a.getClassifier().isEmpty()) {
            buf.append(':').append(a.getClassifier());
        }
        if (!a.getExtension().equals("jar")) {
            if (a.getClassifier().isEmpty()) {
                buf.append(':');
            }
            buf.append(':').append(a.getExtension());
        }
        return buf.toString();
    }

    private String percentage(long part, long whole) {
        return this.format((double)part * 100.0 / (double)whole);
    }

    private String format(double d) {
        return this.numberFormat().format(d);
    }

    private NumberFormat numberFormat() {
        if (this.numberFormat == null) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            numberFormat.setRoundingMode(RoundingMode.HALF_DOWN);
            this.numberFormat = numberFormat;
        }
        return this.numberFormat;
    }

    public class Config {
        private Config() {
        }

        public void report(BomDiff bomDiff) {
            HtmlBomDiffReportGenerator.this.report(bomDiff);
        }
    }
}

