/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.NoopDecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.devtools.messagewriter.MessageWriter;
import org.eclipse.aether.artifact.Artifact;

public class DecomposedBomReleasesLogger
extends NoopDecomposedBomVisitor {
    private MessageWriter log;
    private Level logLevel = Level.INFO;
    private Level conflictLogLevel;
    private Level resolvableConflictLogLevel;
    private Conflict conflict = Conflict.NONE;
    private final StringBuilder buf = new StringBuilder();
    private int originCounter;
    private int releaseCounter;
    private int artifactCounter;
    private int originWithConflictCounter;
    private int resolvableConflictCounter;
    private int unresolvableConflictCounter;

    public static Config config() {
        return new DecomposedBomReleasesLogger().new Config();
    }

    public static Config config(boolean skipOriginsWithSingleRelease) {
        return new DecomposedBomReleasesLogger(skipOriginsWithSingleRelease).new Config();
    }

    public DecomposedBomReleasesLogger() {
    }

    public DecomposedBomReleasesLogger(boolean skipOriginsWithSingleRelease) {
        super(skipOriginsWithSingleRelease);
    }

    private MessageWriter logger() {
        return this.log == null ? (this.log = MessageWriter.info()) : this.log;
    }

    private StringBuilder buf() {
        this.buf.setLength(0);
        return this.buf;
    }

    @Override
    public void enterBom(Artifact bomArtifact) {
        this.log(this.buf().append("Multi Module Project Releases Detected Among The Managed Dependencies of ").append(bomArtifact));
        if (this.skipOriginsWithSingleRelease) {
            this.log("(release origins with a single release were filtered out)");
        }
    }

    @Override
    public boolean enterReleaseOrigin(ReleaseOrigin releaseOrigin, int versions) {
        boolean result = super.enterReleaseOrigin(releaseOrigin, versions);
        if (result) {
            if (versions > 1) {
                this.conflict = Conflict.CONFLICT;
                ++this.originWithConflictCounter;
            }
            ++this.originCounter;
            this.log(this.buf().append("Origin: ").append(releaseOrigin));
        }
        return result;
    }

    @Override
    public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
        super.leaveReleaseOrigin(releaseOrigin);
        this.conflict = Conflict.NONE;
    }

    @Override
    public void visitProjectRelease(ProjectRelease release) {
        ++this.releaseCounter;
        this.log("  " + release.id().version());
        for (ProjectDependency dep : release.dependencies()) {
            ++this.artifactCounter;
            StringBuilder buf = this.buf();
            buf.append("    ").append(dep);
            if (dep.isUpdateAvailable()) {
                buf.append(" -> ").append(dep.availableUpdate().artifact().getVersion());
            }
            if (dep.updateStatus() != ProjectDependency.UpdateStatus.UNKNOWN && this.conflict == Conflict.CONFLICT) {
                if (dep.updateStatus() == ProjectDependency.UpdateStatus.AVAILABLE) {
                    ++this.resolvableConflictCounter;
                    this.conflict = Conflict.RESOLVABLE;
                } else {
                    ++this.unresolvableConflictCounter;
                }
            }
            this.log(buf);
            if (this.conflict != Conflict.RESOLVABLE) continue;
            this.conflict = Conflict.CONFLICT;
        }
    }

    @Override
    public void leaveBom() throws BomDecomposerException {
        if (this.originCounter == 0) {
            return;
        }
        Level level = this.totalLogLevel();
        this.log(level, "TOTAL");
        this.log(level, this.buf().append("  Release origins:                ").append(this.originCounter));
        if (this.originWithConflictCounter > 0) {
            this.log(level, this.buf().append("  Release origins with conflicts: ").append(this.originWithConflictCounter));
        }
        this.log(level, this.buf().append("  Release versions:               ").append(this.releaseCounter));
        this.log(level, this.buf().append("  Artifacts:                      ").append(this.artifactCounter));
        if (this.resolvableConflictCounter > 0) {
            this.log(level, this.buf().append("  Resolvable version conflicts:   ").append(this.resolvableConflictCounter));
        }
        if (this.unresolvableConflictCounter > 0) {
            this.log(level, this.buf().append("  Unresolvable version conflicts: ").append(this.unresolvableConflictCounter));
        }
        if (level == Level.ERROR) {
            throw new BomDecomposerException("There have been version conflicts, please refer to the messages logged above");
        }
    }

    private Level totalLogLevel() {
        Level level = this.resolvableConflictCounter > 0 ? this.resolvableConflictLogLevel : null;
        level = this.originWithConflictCounter > 0 ? this.higherLevel(this.conflictLogLevel, level) : level;
        return this.higherLevel(level, this.logLevel);
    }

    private Level higherLevel(Level l1, Level l2) {
        if (l1 == Level.ERROR || l2 == Level.ERROR) {
            return Level.ERROR;
        }
        if (l1 == Level.WARN || l2 == Level.WARN) {
            return Level.WARN;
        }
        if (l1 == Level.INFO || l2 == Level.INFO) {
            return Level.INFO;
        }
        return l2 == null ? l1 : l2;
    }

    private Level conflictLogLevel() {
        return this.conflictLogLevel == null ? this.logLevel : this.conflictLogLevel;
    }

    private Level resolvableConflictLogLevel() {
        return this.resolvableConflictLogLevel == null ? this.conflictLogLevel() : this.resolvableConflictLogLevel;
    }

    private void log(Object msg) {
        switch (this.conflict) {
            case RESOLVABLE: {
                this.log(this.resolvableConflictLogLevel(), msg);
                break;
            }
            case CONFLICT: {
                this.log(this.conflictLogLevel(), msg);
                break;
            }
            default: {
                this.log(this.logLevel, msg);
            }
        }
    }

    private void log(Level level, Object msg) {
        switch (level) {
            case DEBUG: {
                this.logger().debug(msg == null ? "null" : msg.toString());
                break;
            }
            case INFO: {
                this.logger().info(msg == null ? "null" : msg.toString());
                break;
            }
            case ERROR: {
                this.logger().error(msg == null ? "null" : msg.toString());
                break;
            }
            default: {
                this.logger().warn(msg == null ? "null" : msg.toString());
            }
        }
    }

    static enum Conflict {
        NONE,
        CONFLICT,
        RESOLVABLE;

    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public class Config {
        private Config() {
        }

        public Config logger(MessageWriter logger) {
            DecomposedBomReleasesLogger.this.log = logger;
            return this;
        }

        public Config defaultLogLevel(Level level) {
            DecomposedBomReleasesLogger.this.logLevel = level;
            return this;
        }

        public Config conflictLogLevel(Level level) {
            DecomposedBomReleasesLogger.this.conflictLogLevel = level;
            return this;
        }

        public Config resolvableConflictLogLevel(Level level) {
            DecomposedBomReleasesLogger.this.resolvableConflictLogLevel = level;
            return this;
        }

        public DecomposedBomReleasesLogger build() {
            return DecomposedBomReleasesLogger.this;
        }
    }
}

