/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DefaultDecomposedBomBuilder;
import io.quarkus.bom.decomposer.DefaultMessageWriter;
import io.quarkus.bom.decomposer.MessageWriter;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.UpdateAvailabilityTransformer;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class BomDecomposer {
    private MessageWriter logger;
    private boolean debug;
    private Artifact bomArtifact;
    private PomResolver bomSource;
    private Iterable<Dependency> artifacts;
    private MavenArtifactResolver mvnResolver;
    private List<ReleaseIdDetector> releaseDetectors = new ArrayList<ReleaseIdDetector>();
    private DecomposedBomBuilder decomposedBuilder;
    private DecomposedBomTransformer transformer;

    public static BomDecomposerConfig config() {
        return new BomDecomposer().new BomDecomposerConfig();
    }

    public static DecomposedBom decompose(String groupId, String artifactId, String version) throws BomDecomposerException {
        BomDecomposer decomposer = new BomDecomposer();
        decomposer.bomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        decomposer.bomSource = PomSource.of(decomposer.bomArtifact);
        return decomposer.decompose();
    }

    private BomDecomposer() {
    }

    private MavenArtifactResolver artifactResolver() throws BomDecomposerException {
        try {
            return this.mvnResolver == null ? (this.mvnResolver = new MavenArtifactResolver(new BootstrapMavenContext(BootstrapMavenContext.config().setArtifactTransferLogging(this.debug)))) : this.mvnResolver;
        }
        catch (AppModelResolverException e) {
            throw new BomDecomposerException("Failed to initialize Maven artifact resolver", e);
        }
    }

    private DecomposedBom decompose() throws BomDecomposerException {
        DecomposedBomBuilder bomBuilder = this.decomposedBuilder == null ? new DefaultDecomposedBomBuilder() : this.decomposedBuilder;
        bomBuilder.bomArtifact(this.bomArtifact);
        Iterable<Dependency> artifacts = this.artifacts == null ? this.bomManagedDeps() : this.artifacts;
        for (Dependency dep : artifacts) {
            try {
                bomBuilder.bomDependency(this.releaseId(dep.getArtifact()), dep);
            }
            catch (BomDecomposerException e) {
                if (e.getCause() instanceof AppModelResolverException) {
                    Object[] params = new Object[]{dep};
                    this.logger().debug("Failed to resolve POM for %s", params);
                    continue;
                }
                throw e;
            }
        }
        return this.transformer == null ? bomBuilder.build() : this.transformer.transform(this, bomBuilder.build());
    }

    private Iterable<Dependency> bomManagedDeps() throws BomDecomposerException {
        return this.describe(this.bomArtifact).getManagedDependencies();
    }

    private ReleaseId releaseId(Artifact artifact) throws BomDecomposerException {
        Model tmp;
        for (ReleaseIdDetector releaseDetector : this.releaseDetectors) {
            ReleaseId releaseId = releaseDetector.detectReleaseId(this, artifact);
            if (releaseId == null) continue;
            return releaseId;
        }
        Model model = this.model(artifact);
        while ((tmp = this.workspaceParent(model)) != null) {
            model = tmp;
        }
        return ReleaseIdFactory.forModel(model);
    }

    private Model workspaceParent(Model model) throws BomDecomposerException {
        if (model.getParent() == null) {
            return null;
        }
        Model parentModel = this.model(Util.parentArtifact(model));
        if (Util.getScmOrigin(model) != null) {
            return Util.getScmOrigin(model).equals(Util.getScmOrigin(parentModel)) && Util.getScmTag(model).equals(Util.getScmTag(parentModel)) ? parentModel : null;
        }
        if (model.getParent().getRelativePath().isEmpty()) {
            return null;
        }
        if (model.getVersion() == null || !"../pom.xml".equals(model.getParent().getRelativePath()) || ModelUtils.getGroupId((Model)parentModel).equals(ModelUtils.getGroupId((Model)model)) && ModelUtils.getVersion((Model)parentModel).equals(ModelUtils.getVersion((Model)model))) {
            return parentModel;
        }
        if (parentModel.getModules().isEmpty()) {
            return null;
        }
        for (String path : parentModel.getModules()) {
            String dirName = Paths.get(path, new String[0]).getFileName().toString();
            if (!model.getArtifactId().contains(dirName)) continue;
            return parentModel;
        }
        return null;
    }

    public MessageWriter logger() {
        return this.logger == null ? (this.logger = new DefaultMessageWriter().setDebugEnabled(this.debug)) : this.logger;
    }

    public Model model(Artifact artifact) throws BomDecomposerException {
        return Util.model(this.resolve(Util.pom(artifact)).getFile());
    }

    public ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        try {
            return this.artifactResolver().resolveDescriptor(artifact);
        }
        catch (Exception e) {
            throw new BomDecomposerException("Failed to resolve artifact descriptor for " + artifact, e);
        }
    }

    public Artifact resolve(Artifact artifact) throws BomDecomposerException {
        try {
            return this.artifactResolver().resolve(artifact).getArtifact();
        }
        catch (Exception e) {
            throw new BomDecomposerException("Failed to resolve artifact " + artifact, e);
        }
    }

    public class BomDecomposerConfig {
        private BomDecomposerConfig() {
        }

        public BomDecomposerConfig logger(MessageWriter messageWriter) {
            BomDecomposer.this.logger = messageWriter;
            return this;
        }

        public BomDecomposerConfig debug() {
            BomDecomposer.this.debug = true;
            return this;
        }

        public BomDecomposerConfig mavenArtifactResolver(MavenArtifactResolver resolver) {
            BomDecomposer.this.mvnResolver = resolver;
            return this;
        }

        public BomDecomposerConfig bomFile(Path bom) {
            BootstrapMavenContext mvnCtx;
            try {
                mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(bom.normalize().toAbsolutePath().toString()));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize bootstrap Maven context", e);
            }
            LocalProject bomProject = mvnCtx.getCurrentProject();
            try {
                this.mavenArtifactResolver(new MavenArtifactResolver(mvnCtx));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver for " + bom, e);
            }
            BomDecomposer.this.bomArtifact = (Artifact)new DefaultArtifact(bomProject.getGroupId(), bomProject.getArtifactId(), "", "pom", bomProject.getVersion());
            BomDecomposer.this.bomSource = PomSource.of(bom);
            return this;
        }

        public BomDecomposerConfig bomArtifact(String groupId, String artifactId, String version) {
            return this.bomArtifact((Artifact)new DefaultArtifact(groupId, artifactId, "", "pom", version));
        }

        public BomDecomposerConfig bomArtifact(Artifact artifact) {
            BomDecomposer.this.bomArtifact = artifact;
            BomDecomposer.this.bomSource = PomSource.of(artifact);
            return this;
        }

        public BomDecomposerConfig addReleaseDetector(ReleaseIdDetector releaseDetector) {
            BomDecomposer.this.releaseDetectors.add(releaseDetector);
            return this;
        }

        public BomDecomposerConfig checkForUpdates() {
            return this.transform(new UpdateAvailabilityTransformer());
        }

        public BomDecomposerConfig transform(DecomposedBomTransformer bomTransformer) {
            BomDecomposer.this.transformer = bomTransformer;
            return this;
        }

        public BomDecomposerConfig dependencies(Iterable<Dependency> iterator) {
            BomDecomposer.this.artifacts = iterator;
            return this;
        }

        public DecomposedBom decompose() throws BomDecomposerException {
            ServiceLoader.load(ReleaseIdDetector.class, Thread.currentThread().getContextClassLoader()).forEach(d -> {
                BomDecomposer.this.logger().debug("Loaded release detector " + d);
                BomDecomposer.this.releaseDetectors.add(d);
            });
            return BomDecomposer.this.decompose();
        }
    }
}

