/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.DecomposedBomReportFileWriter;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public class DecomposedBomHtmlReportGenerator
extends DecomposedBomReportFileWriter {
    private static final String[] listBackground = new String[]{"background-color:#EBF4FA", "background-color:#FFFFFF"};
    private static String RED = "Red";
    private static String GREEN = "Green";
    private static String BLUE = "Blue";
    private int releaseOriginsTotal;
    private int releaseVersionsTotal;
    private int artifactsTotal;
    private int releaseOriginsWithConflictsTotal;
    private int resolvableConflictsTotal;
    private int unresolvableConflictsTotal;
    private boolean skipOriginsWithSingleRelease;
    private Map<String, Map<String, ProjectDependency>> allDeps = new HashMap<String, Map<String, ProjectDependency>>();
    private int originReleaseVersions;
    private List<ArtifactVersion> releaseVersions = new ArrayList<ArtifactVersion>();

    public static HtmlWriterBuilder builder(String file) {
        return new DecomposedBomHtmlReportGenerator(file).new HtmlWriterBuilder();
    }

    public static HtmlWriterBuilder builder(Path file) {
        return new DecomposedBomHtmlReportGenerator(file).new HtmlWriterBuilder();
    }

    private DecomposedBomHtmlReportGenerator(String file) {
        super(file);
    }

    private DecomposedBomHtmlReportGenerator(Path file) {
        super(file);
    }

    @Override
    protected void writeStartBom(BufferedWriter writer, Artifact bomArtifact) throws IOException {
        this.writeLine("<!DOCTYPE html>");
        this.openTag("html");
        this.openTag("head");
        this.offsetLine("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
        this.openTag("style");
        this.writeLine(".accordion {\n  background-color: #eee;\n  color: #444;\n  cursor: pointer;\n  padding: 18px;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-size: 15px;\n  transition: 0.4s;\n}");
        this.writeLine(".active, .accordion:hover {\n  background-color: #ccc; \n}");
        this.writeLine(".panel {\n  padding: 0 18px;\n  display: none;\n  background-color: white;\n  overflow: hidden;\n}");
        this.closeTag("style");
        this.closeTag("head");
        this.openTag("body");
        this.writeTag("h1", "Multi Module Project Releases Report");
        this.writeTag("p", "Includes multi module project releases detected among the managed dependencies of the BOM");
        if (this.skipOriginsWithSingleRelease) {
            this.writeTag("p", "font-weight:bold;color:" + RED, "Release origins with a single release were filtered out");
        }
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "BOM:");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "groupId:");
        this.writeTag("td", "font-weight:bold", bomArtifact.getGroupId());
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "artifactId:");
        this.writeTag("td", "font-weight:bold", bomArtifact.getArtifactId());
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", "version:");
        this.writeTag("td", "font-weight:bold", bomArtifact.getVersion());
        this.closeTag("tr");
        this.closeTag("table");
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "Colors highlighting the versions:");
        this.openTag("tr");
        this.writeTag("th", "text-align:left;color:" + BLUE, "Blue");
        this.writeTag("td", "- version of the artifact found in the BOM which is either the preferred version or an older version for which the preferred version is not available");
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("th", "text-align:left;color:" + RED, "Red");
        this.writeTag("td", "- old version of the artifact found in the BOM for which the preferred version is available in the Maven repository");
        this.closeTag("tr");
        this.openTag("tr");
        this.writeTag("th", "text-align:left;color:" + GREEN, "Green");
        this.writeTag("td", "- the preferred version of the artifact found to be available in the Maven repository");
        this.closeTag("tr");
        this.closeTag("table");
        this.openTag("p");
        this.closeTag("p");
    }

    @Override
    protected boolean writeStartReleaseOrigin(BufferedWriter writer, ReleaseOrigin releaseOrigin, int versions) throws IOException {
        this.originReleaseVersions = versions;
        if (versions > 1) {
            ++this.releaseOriginsWithConflictsTotal;
        }
        return versions > 1 || !this.skipOriginsWithSingleRelease;
    }

    @Override
    protected void writeEndReleaseOrigin(BufferedWriter writer, ReleaseOrigin releaseOrigin) throws IOException {
        this.offsetLine("<button class=\"accordion\">" + releaseOrigin + (this.originReleaseVersions > 1 ? " (" + this.originReleaseVersions + ")" : "") + "</button>");
        this.offsetLine("<div class=\"panel\">");
        Collections.sort(this.releaseVersions);
        List stringVersions = this.releaseVersions.stream().map(v -> v.toString()).collect(Collectors.toList());
        this.openTag("table");
        int i = 1;
        for (String releaseVersionStr : stringVersions) {
            Map<String, ProjectDependency> releaseDeps = this.allDeps.get(releaseVersionStr);
            ArrayList<String> sortedKeys = new ArrayList<String>(releaseDeps.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                this.openTag("tr");
                this.writeTag("td", i++ + ")");
                ProjectDependency dep = releaseDeps.get(key);
                this.writeTag("td", dep.artifact());
                for (int j = 0; j < stringVersions.size(); ++j) {
                    String version = (String)stringVersions.get(j);
                    if (dep.releaseId().version().asString().equals(version)) {
                        this.writeTag("td", !dep.isUpdateAvailable() || j == stringVersions.size() - 1 ? "color:" + BLUE : "color:" + RED, version);
                        continue;
                    }
                    if (dep.isUpdateAvailable() && dep.availableUpdate().releaseId().version().asString().equals(version)) {
                        this.writeTag("td", "color:" + GREEN, version);
                        continue;
                    }
                    this.emptyTag("td");
                }
                if (dep.updateStatus() != ProjectDependency.UpdateStatus.UNKNOWN && this.originReleaseVersions > 1) {
                    if (dep.updateStatus() == ProjectDependency.UpdateStatus.AVAILABLE) {
                        ++this.resolvableConflictsTotal;
                    } else {
                        ++this.unresolvableConflictsTotal;
                    }
                }
                this.closeTag("tr");
            }
        }
        this.closeTag("table");
        this.offsetLine("</div>");
        ++this.releaseOriginsTotal;
        this.allDeps.clear();
        this.releaseVersionsTotal += this.releaseVersions.size();
        this.releaseVersions.clear();
    }

    @Override
    protected void writeProjectRelease(BufferedWriter writer, ProjectRelease release) throws IOException {
        List<ProjectDependency> deps = release.dependencies();
        this.releaseVersions.add((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString()));
        HashMap<String, ProjectDependency> releaseDeps = new HashMap<String, ProjectDependency>(deps.size());
        this.allDeps.put(release.id().version().asString(), releaseDeps);
        for (ProjectDependency dep : deps) {
            releaseDeps.put(dep.key().toString(), dep);
        }
        this.artifactsTotal += deps.size();
    }

    @Override
    protected void writeEndBom(BufferedWriter writer) throws IOException {
        int backgroundIndex = 0;
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "Total:");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Resolvable version conflicts:");
        this.writeTag("td", "text-align:right;", this.resolvableConflictsTotal);
        this.closeTag("tr");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Unresolvable version conflicts:");
        this.writeTag("td", "text-align:right;", this.unresolvableConflictsTotal);
        this.closeTag("tr");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Release origins:");
        this.writeTag("td", "text-align:right;", this.releaseOriginsTotal);
        this.closeTag("tr");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Release origins with conflicts:");
        this.writeTag("td", "text-align:right;", this.releaseOriginsWithConflictsTotal);
        this.closeTag("tr");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Release versions:");
        this.writeTag("td", "text-align:right;", this.releaseVersionsTotal);
        this.closeTag("tr");
        this.openTag("tr", listBackground[backgroundIndex ^= 1]);
        this.writeTag("td", "text-align:left;", "Artifacts:");
        this.writeTag("td", "text-align:right;", this.artifactsTotal);
        this.closeTag("tr");
        this.closeTag("table");
        this.openTag("script");
        this.writeLine("var acc = document.getElementsByClassName(\"accordion\");\nvar i;\nfor (i = 0; i < acc.length; i++) {\n  acc[i].addEventListener(\"click\", function() {\n    this.classList.toggle(\"active\");\n    var panel = this.nextElementSibling;\n    if (panel.style.display === \"block\") {\n      panel.style.display = \"none\";\n    } else {\n      panel.style.display = \"block\";\n    }\n  });\n}");
        this.closeTag("script");
        this.closeTag("body");
        this.closeTag("html");
    }

    public class HtmlWriterBuilder {
        private HtmlWriterBuilder() {
        }

        public HtmlWriterBuilder indentChars(int indent) {
            this.indentChars(indent);
            return this;
        }

        public HtmlWriterBuilder skipOriginsWithSingleRelease() {
            DecomposedBomHtmlReportGenerator.this.skipOriginsWithSingleRelease = true;
            return this;
        }

        public DecomposedBomHtmlReportGenerator build() {
            return DecomposedBomHtmlReportGenerator.this;
        }
    }
}

