/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bom.decomposer.ReleaseVersion;
import org.eclipse.aether.artifact.Artifact;

public class BouncyCastleReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.bouncycastle")) {
            ReleaseId releaseId = releaseResolver.defaultReleaseId(artifact);
            Object version = releaseId.version().asString();
            if (((String)version).startsWith("r") && ((String)version).contains("rv")) {
                return releaseId;
            }
            int i = ((String)version).indexOf(46);
            if (i < 0) {
                return releaseId;
            }
            version = "r" + ((String)version).substring(0, i) + "rv" + ((String)version).substring(i + 1);
            return ReleaseIdFactory.create(releaseId.origin(), ReleaseVersion.Factory.tag((String)version));
        }
        return null;
    }
}

