/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import org.eclipse.aether.artifact.Artifact;

public class GoogleApiCommonReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("com.google.api") && artifact.getArtifactId().equals("api-common")) {
            ReleaseId releaseId = releaseResolver.defaultReleaseId(artifact);
            if (releaseId.version().isTag()) {
                return releaseId;
            }
            ReleaseOrigin origin = releaseId.origin();
            if (origin.isUrl() && origin.toString().equals("https://github.com/googleapis/sdk-platform-java")) {
                return ReleaseIdFactory.create(ReleaseOrigin.Factory.ga("com.google.api", "api-common"), ReleaseVersion.Factory.version(artifact.getVersion()));
            }
        }
        return null;
    }
}

