/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import org.eclipse.aether.artifact.Artifact;

public class ReactiveStreamsReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.reactivestreams")) {
            ReleaseId releaseId = releaseResolver.defaultReleaseId(artifact);
            Object repoUrl = releaseId.origin().toString();
            Object tag = releaseId.version().asString();
            if (!((String)repoUrl).endsWith("reactive-streams-jvm")) {
                repoUrl = ((String)repoUrl).substring(0, ((String)repoUrl).lastIndexOf(47) + 1);
                repoUrl = (String)repoUrl + "reactive-streams-jvm";
            }
            if (((String)tag).charAt(0) != 'v') {
                tag = "v" + (String)tag;
            }
            return ReleaseIdFactory.forScmAndTag((String)repoUrl, (String)tag);
        }
        return null;
    }
}

