/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom;

import io.quarkus.bom.PomResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class UrlPomResolver
implements PomResolver {
    private final URL baseUrl;
    private Artifact pomArtifact;
    private Model model;

    public UrlPomResolver(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public Path pomPath() {
        return Paths.get(this.baseUrl.getPath(), new String[0]);
    }

    @Override
    public Model readLocalModel(Path pom) throws IOException {
        Object path = pom.toUri().getPath();
        if (this.baseUrl.getPath().equals(path)) {
            return this.model();
        }
        if (!((String)path).endsWith(".xml")) {
            path = (String)path + "/pom.xml";
        }
        URL url = new URL(this.baseUrl.getProtocol(), this.baseUrl.getHost(), this.baseUrl.getPort(), (String)path);
        return this.loadModel(url);
    }

    @Override
    public Model model() {
        return this.model == null ? (this.model = this.loadModel(this.baseUrl)) : this.model;
    }

    private Model loadModel(URL url) {
        Model model;
        block8: {
            InputStream stream = url.openStream();
            try {
                model = ModelUtils.readModel((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            stream.close();
        }
        return model;
    }

    @Override
    public String source() {
        return this.baseUrl.toExternalForm();
    }

    @Override
    public Artifact pomArtifact() {
        if (this.pomArtifact == null) {
            Model model = this.model();
            this.pomArtifact = new DefaultArtifact(ModelUtils.getGroupId((Model)model), model.getArtifactId(), null, "pom", ModelUtils.getVersion((Model)model));
        }
        return this.pomArtifact;
    }

    @Override
    public boolean isResolved() {
        return this.baseUrl.getProtocol().equals("file");
    }
}

