/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import java.util.Objects;

public interface ReleaseOrigin
extends Comparable<ReleaseOrigin> {
    public boolean isUrl();

    public static class GaOrigin
    implements ReleaseOrigin {
        final String groupId;
        final String artifactId;

        GaOrigin(String groupId, String artifactId) {
            this.groupId = Objects.requireNonNull(groupId);
            this.artifactId = Objects.requireNonNull(artifactId);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId;
        }

        public int hashCode() {
            return Objects.hash(this.artifactId, this.groupId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GaOrigin other = (GaOrigin)obj;
            return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId);
        }

        @Override
        public int compareTo(ReleaseOrigin o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public boolean isUrl() {
            return false;
        }
    }

    public static class ScmConnectionOrigin
    implements ReleaseOrigin {
        final String connection;

        ScmConnectionOrigin(String connection) {
            this.connection = Objects.requireNonNull(connection);
        }

        public String toString() {
            return this.connection;
        }

        public int hashCode() {
            return Objects.hash(this.connection);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScmConnectionOrigin other = (ScmConnectionOrigin)obj;
            return Objects.equals(this.connection, other.connection);
        }

        @Override
        public int compareTo(ReleaseOrigin o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public boolean isUrl() {
            return true;
        }
    }

    public static class Factory {
        public static ReleaseOrigin scmConnection(String connection) {
            return new ScmConnectionOrigin(connection);
        }

        public static ReleaseOrigin ga(String groupId, String artifactId) {
            return new GaOrigin(groupId, artifactId);
        }
    }
}

