/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import org.eclipse.aether.artifact.Artifact;

public class HapiFhirReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("ca.uhn.hapi.fhir")) {
            ReleaseVersion version;
            ReleaseId releaseId = releaseResolver.defaultReleaseId(artifact);
            ReleaseOrigin origin = releaseId.origin();
            if (!"https://github.com/hapifhir/hapi-fhir".equals(origin.toString())) {
                origin = ReleaseOrigin.Factory.scmConnection("https://github.com/hapifhir/hapi-fhir");
            }
            if (!(version = releaseId.version()).asString().startsWith("v")) {
                version = ReleaseVersion.Factory.tag("v" + version.asString());
            }
            return ReleaseIdFactory.create(origin, version);
        }
        return null;
    }
}

