/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.GAV;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ScmRevisionResolver {
    private final MessageWriter log;
    private final ArtifactResolver resolver;
    private final Collection<ReleaseIdDetector> releaseDetectors;
    private final boolean validateRepoTag;
    private Set<ScmRevision> validatedReleaseIds;
    private HttpClient httpClient;
    private final Map<GAV, ScmRevision> releaseIdCache = new WeakHashMap<GAV, ScmRevision>();

    public ScmRevisionResolver(MavenArtifactResolver resolver) {
        this(ArtifactResolverProvider.get(resolver));
    }

    public ScmRevisionResolver(MavenArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors) {
        this(ArtifactResolverProvider.get(resolver), releaseDetectors);
    }

    public ScmRevisionResolver(MavenArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors, MessageWriter log, boolean validateRepoTag) {
        this(ArtifactResolverProvider.get(resolver), releaseDetectors, log, validateRepoTag);
    }

    public ScmRevisionResolver(ArtifactResolver resolver) {
        this(resolver, List.of());
    }

    public ScmRevisionResolver(ArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors) {
        this.resolver = Objects.requireNonNull(resolver);
        this.releaseDetectors = releaseDetectors;
        this.validateRepoTag = false;
        this.log = MessageWriter.info();
    }

    public ScmRevisionResolver(ArtifactResolver resolver, Collection<ReleaseIdDetector> releaseDetectors, MessageWriter log, boolean validateRepoTag) {
        this.resolver = Objects.requireNonNull(resolver);
        this.releaseDetectors = releaseDetectors;
        this.validateRepoTag = validateRepoTag;
        this.log = log;
    }

    public ScmRevision resolveRevision(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException, UnresolvableModelException {
        GAV gav = new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ScmRevision releaseId = this.releaseIdCache.get(gav);
        if (releaseId == null) {
            ReleaseIdDetector releaseDetector;
            Iterator<ReleaseIdDetector> iterator = this.releaseDetectors.iterator();
            while (iterator.hasNext() && (releaseId = (releaseDetector = iterator.next()).detectReleaseId(this, artifact)) == null) {
            }
            if (releaseId == null) {
                releaseId = this.readRevisionFromPom(artifact, repos);
            }
            if (this.validateRepoTag) {
                this.validateTag(releaseId);
            }
            this.releaseIdCache.put(gav, releaseId);
        }
        return releaseId;
    }

    public ScmRevision readRevisionFromPom(Artifact artifact) throws BomDecomposerException {
        return this.readRevisionFromPom(artifact, List.of());
    }

    public ScmRevision readRevisionFromPom(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException {
        Model tmp;
        Model model = this.readPom(artifact, repos);
        while (!ScmRevisionResolver.hasScmInfo(model) && (tmp = this.workspaceParent(model, repos)) != null) {
            model = tmp;
        }
        return ReleaseIdFactory.forModel(model);
    }

    public ScmRevision validateTag(ScmRevision releaseId) {
        if (this.validatedReleaseIds == null) {
            this.validatedReleaseIds = new HashSet<ScmRevision>();
        }
        if (!this.validatedReleaseIds.add(releaseId)) {
            return releaseId;
        }
        Object repoUrl = releaseId.getRepository().getId();
        if (!((String)repoUrl).startsWith("https:") && !((String)repoUrl).startsWith("http:")) {
            this.log.warn("Non-HTTP(s) origin " + (String)repoUrl);
            return releaseId;
        }
        if (((String)repoUrl).charAt(((String)repoUrl).length() - 1) != '/') {
            repoUrl = (String)repoUrl + "/";
        }
        if (((String)repoUrl).contains("github.com")) {
            repoUrl = (String)repoUrl + "releases/tag/";
        } else if (((String)repoUrl).contains("gitlab.com")) {
            repoUrl = (String)repoUrl + "-/tags/";
        }
        repoUrl = (String)repoUrl + releaseId.getValue();
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newHttpClient();
        }
        try {
            Object tagUrl = repoUrl;
            this.httpClient.send(HttpRequest.newBuilder().GET().uri(URI.create((String)repoUrl)).timeout(Duration.ofSeconds(5L)).build(), arg_0 -> this.lambda$validateTag$0((String)tagUrl, arg_0));
        }
        catch (Exception e) {
            this.log.warn("Invalid release tag " + (String)repoUrl);
        }
        return releaseId;
    }

    private static boolean hasScmInfo(Model model) {
        return Util.getScmOrigin(model) != null;
    }

    private Model workspaceParent(Model model, List<RemoteRepository> repos) throws BomDecomposerException {
        if (model.getParent() == null) {
            return null;
        }
        Model parentModel = this.readPom(Util.parentArtifact(model), repos);
        if (Util.getScmOrigin(model) != null) {
            return Util.getScmOrigin(model).equals(Util.getScmOrigin(parentModel)) && Util.getScmTag(model).equals(Util.getScmTag(parentModel)) ? parentModel : null;
        }
        if (model.getParent().getRelativePath().isEmpty()) {
            return null;
        }
        if (model.getVersion() == null || model.getParent().getRelativePath() != null && !model.getParent().getRelativePath().startsWith("../pom.xml") || ModelUtils.getGroupId((Model)parentModel).equals(ModelUtils.getGroupId((Model)model)) && ModelUtils.getVersion((Model)parentModel).equals(ModelUtils.getVersion((Model)model))) {
            return parentModel;
        }
        if (parentModel.getModules().isEmpty()) {
            return null;
        }
        for (String path : parentModel.getModules()) {
            String dirName = Paths.get(path, new String[0]).getFileName().toString();
            if (!model.getArtifactId().contains(dirName)) continue;
            return parentModel;
        }
        return null;
    }

    public Model readPom(Artifact artifact) throws BomDecomposerException {
        return Util.model(this.resolver.resolve(Util.pom(artifact)).getArtifact().getFile());
    }

    public Model readPom(Artifact artifact, List<RemoteRepository> repos) throws BomDecomposerException {
        return Util.model(this.resolver.resolve(Util.pom(artifact), repos).getArtifact().getFile());
    }

    private /* synthetic */ HttpResponse.BodySubscriber lambda$validateTag$0(String tagUrl, HttpResponse.ResponseInfo r) {
        switch (r.statusCode()) {
            case 200: 
            case 429: {
                break;
            }
            default: {
                this.log.warn("Got " + r.statusCode() + " response code validating " + tagUrl);
            }
        }
        return HttpResponse.BodySubscribers.discarding();
    }
}

