/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ScmRevisionResolver;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import org.eclipse.aether.artifact.Artifact;

public class CommonsIoReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("commons-io")) {
            String[] arr;
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            ScmRepository origin = releaseId.getRepository();
            if (!origin.hasUrl() || !origin.getUrl().equals("https://github.com/apache/commons-io")) {
                origin = ScmRepository.ofUrl("https://github.com/apache/commons-io");
            }
            if ("2".equals((arr = artifact.getVersion().split("\\."))[0]) && Integer.parseInt(arr[1]) < 7) {
                return ScmRevision.tag(origin, "commons-io-" + artifact.getVersion());
            }
            return ScmRevision.tag(origin, "rel/commons-io-" + artifact.getVersion());
        }
        return null;
    }
}

