/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ScmRevisionResolver;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import org.eclipse.aether.artifact.Artifact;

public class LogbackReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("ch.qos.logback")) {
            Object version;
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            ScmRepository origin = releaseId.getRepository();
            if (!origin.hasUrl() || !origin.getUrl().equals("https://github.com/qos-ch/logback")) {
                origin = ScmRepository.ofUrl("https://github.com/qos-ch/logback");
            }
            if (!((String)(version = releaseId.getValue())).startsWith("v_")) {
                version = "v_" + artifact.getVersion();
            }
            return ScmRevision.tag(origin, (String)version);
        }
        return null;
    }
}

