/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.FileReportWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ReportIndexPageGenerator
extends FileReportWriter
implements AutoCloseable {
    private static final String[] listBackground = new String[]{"background-color:#EBF4FA", "background-color:#FFFFFF"};
    private URL mainBomUrl;
    private DecomposedBom mainBom;
    private Path mainBomReleasesHtml;
    private final Collection<MemberData> memberData = new ConcurrentLinkedDeque<MemberData>();

    public ReportIndexPageGenerator(Path file) throws IOException {
        super(file);
        this.initHtmlBody();
    }

    private void completeHtmlBody() throws IOException {
        this.generateContents();
        this.closeTag("body");
        this.closeTag("html");
    }

    private void initHtmlBody() throws IOException {
        try {
            this.writeLine("<!DOCTYPE html>");
            this.openTag("html");
            this.openTag("head");
            this.offsetLine("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            this.closeTag("head");
            this.openTag("body");
            this.writeTag("h1", "Platform BOM Summary");
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void generateContents() throws IOException {
        this.writeTag("p", "");
        this.writeTag("h2", "Platform BOM");
        int backgroundIndex = 1;
        if (this.mainBomUrl != null) {
            this.openTag("table");
            this.openTag("tr", listBackground[backgroundIndex]);
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", this.mainBom.bomArtifact());
            this.writeTag("td", "text-align:left", this.generateAnchor(this.mainBomUrl.toExternalForm(), "generated"));
            this.writeTag("td", "text-align:left", this.generateAnchor(this.mainBomReleasesHtml.toUri().toURL().toExternalForm(), "decomposed"));
            this.closeTag("tr");
            this.closeTag("table");
        }
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "Extension BOMs");
        for (MemberData member : this.memberData) {
            this.openTag("tr", listBackground[backgroundIndex ^= 1]);
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", member.toBom.bomArtifact());
            this.writeTag("td", "text-align:left", this.generateAnchor(member.mainUrl.toExternalForm(), "original"));
            this.writeTag("td", "text-align:left", this.generateAnchor(member.mainReleasesHtml.toUri().toURL().toExternalForm(), "decomposed"));
            this.writeTag("td", "text-align:left", this.generateAnchor(member.toUrl.toExternalForm(), "generated"));
            this.writeTag("td", "text-align:left", this.generateAnchor(member.toReleasesHtml.toUri().toURL().toExternalForm(), "decomposed"));
            this.writeTag("td", "text-align:left", this.generateAnchor(member.diffHtml.toUri().toURL().toExternalForm(), "diff"));
            this.closeTag("tr");
        }
        this.closeTag("table");
    }

    public void universalBom(URL mainUrl, DecomposedBom decomposed, Path releasesHtml) {
        this.mainBomUrl = mainUrl;
        this.mainBom = decomposed;
        this.mainBomReleasesHtml = releasesHtml;
    }

    public void bomReport(URL mainUrl, URL toUrl, DecomposedBom toBom, Path mainReleasesHtml, Path toReleasesHtml, Path diffHtml) {
        this.memberData.add(new MemberData(mainUrl, toUrl, toBom, mainReleasesHtml, toReleasesHtml, diffHtml));
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                this.completeHtmlBody();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    private static class MemberData {
        final URL mainUrl;
        final URL toUrl;
        final DecomposedBom toBom;
        final Path mainReleasesHtml;
        final Path toReleasesHtml;
        final Path diffHtml;

        public MemberData(URL mainUrl, URL toUrl, DecomposedBom toBom, Path mainReleasesHtml, Path toReleasesHtml, Path diffHtml) {
            this.mainUrl = mainUrl;
            this.toUrl = toUrl;
            this.toBom = toBom;
            this.mainReleasesHtml = mainReleasesHtml;
            this.toReleasesHtml = toReleasesHtml;
            this.diffHtml = diffHtml;
        }
    }
}

