/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform.version;

import io.quarkus.bom.platform.version.PlatformVersionIncrementor;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.pnc.PncVersionProvider;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class PncVersionIncrementor
implements PlatformVersionIncrementor {
    private final PlatformVersionIncrementor baseIncrementor;

    public PncVersionIncrementor() {
        this(null);
    }

    public PncVersionIncrementor(PlatformVersionIncrementor baseIncrementor) {
        this.baseIncrementor = baseIncrementor;
    }

    @Override
    public String nextVersion(String groupId, String artifactId, String baseVersion, String lastVersion) {
        String prevBaseVersion;
        DefaultArtifactVersion prevV;
        if (this.baseIncrementor != null) {
            String baseNextVersion = this.baseIncrementor.nextVersion(groupId, artifactId, baseVersion, lastVersion);
            return PncVersionProvider.getNextRedHatBuildVersion((String)groupId, (String)artifactId, (String)baseNextVersion);
        }
        String upstreamBaseVersion = RhVersionPattern.ensureNoRhQualifier((String)baseVersion);
        String rhQualifier = baseVersion.substring(upstreamBaseVersion.length());
        DefaultArtifactVersion v = new DefaultArtifactVersion(upstreamBaseVersion);
        if (lastVersion != null && (prevV = new DefaultArtifactVersion(prevBaseVersion = RhVersionPattern.ensureNoRhQualifier((String)lastVersion))).getMajorVersion() == v.getMajorVersion() && prevV.getMinorVersion() == v.getMinorVersion() && prevV.getIncrementalVersion() == v.getIncrementalVersion() && prevV.compareTo((ArtifactVersion)v) > 0) {
            upstreamBaseVersion = prevBaseVersion;
            v = prevV;
        }
        return PncVersionProvider.getNextRedHatBuildVersion((String)groupId, (String)artifactId, (String)v.toString());
    }
}

