/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.platform.ExtensionDeps;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PlatformMemberExtensions {
    private final PlatformMember member;
    private final Map<ArtifactKey, ExtensionDeps> extDeps = new HashMap<ArtifactKey, ExtensionDeps>();

    PlatformMemberExtensions(PlatformMember member) {
        this.member = member;
    }

    void addExtension(ExtensionDeps ext) {
        for (ExtensionDeps e : this.extDeps.values()) {
            if (e.isRuntimeDep(ext.key())) {
                e.addExtensionDep(ext);
                continue;
            }
            if (!ext.isRuntimeDep(e.key())) continue;
            ext.addExtensionDep(e);
        }
        this.extDeps.put(ext.key(), ext);
    }

    ExtensionDeps getExtension(ArtifactKey extKey) {
        ExtensionDeps ext = this.extDeps.get(extKey);
        if (ext == null) {
            throw new IllegalArgumentException(String.valueOf(this.member.key()) + " does not include extension " + String.valueOf(extKey));
        }
        return ext;
    }

    Collection<ExtensionDeps> getFilteredOutExtensions() {
        Collection<ArtifactKey> extCatalog = this.member.extensionCatalog();
        if (extCatalog.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionDeps> list = new ArrayList<ExtensionDeps>(this.extDeps.size() - extCatalog.size());
        TreeMap<ArtifactKey, List> nonProdDeps = null;
        for (ExtensionDeps extensionDeps : this.extDeps.values()) {
            if (!extCatalog.contains(extensionDeps.key())) {
                list.add(extensionDeps);
                continue;
            }
            for (ArtifactKey d : extensionDeps.getExtensionDeps()) {
                if (extCatalog.contains(d)) continue;
                if (nonProdDeps == null) {
                    nonProdDeps = new TreeMap<ArtifactKey, List>(ArtifactKeyComparator.getInstance());
                }
                nonProdDeps.computeIfAbsent(d, k -> new ArrayList()).add(extensionDeps.key());
            }
        }
        if (nonProdDeps != null) {
            for (Map.Entry entry : nonProdDeps.entrySet()) {
                System.out.println("Not supported extension " + String.valueOf(entry.getKey()) + " is a dependency of supported extensions:");
                Collections.sort((List)entry.getValue(), ArtifactKeyComparator.getInstance());
                for (ArtifactKey k2 : (List)entry.getValue()) {
                    System.out.println(" - " + String.valueOf(k2));
                }
            }
        }
        return list;
    }

    private static class ArtifactKeyComparator
    implements Comparator<ArtifactKey> {
        private static ArtifactKeyComparator instance;

        private ArtifactKeyComparator() {
        }

        static ArtifactKeyComparator getInstance() {
            return instance == null ? (instance = new ArtifactKeyComparator()) : instance;
        }

        @Override
        public int compare(ArtifactKey o1, ArtifactKey o2) {
            int i = o1.getGroupId().compareTo(o2.getGroupId());
            if (i != 0) {
                return i;
            }
            i = o1.getArtifactId().compareTo(o2.getArtifactId());
            if (i != 0) {
                return i;
            }
            i = o1.getClassifier().compareTo(o2.getClassifier());
            if (i != 0) {
                return i;
            }
            i = o1.getType().compareTo(o2.getType());
            if (i != 0) {
                return i;
            }
            return 0;
        }
    }
}

