/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.graph.Dependency;

class ProjectReleaseCollector {
    private final Map<ScmRepository, ReleaseOriginBuilder> originBuilders = new HashMap<ScmRepository, ReleaseOriginBuilder>();

    ProjectReleaseCollector() {
    }

    ProjectRelease.Builder getOrCreateReleaseBuilder(ScmRevision releaseId, PlatformMember member) {
        ReleaseOriginBuilder releaseBuilder = this.originBuilders.computeIfAbsent(releaseId.getRepository(), id -> new ReleaseOriginBuilder());
        releaseBuilder.members.putIfAbsent(member.key(), member);
        return releaseBuilder.builders.computeIfAbsent(releaseId.getValue(), id -> ProjectRelease.builder((ScmRevision)releaseId));
    }

    Collection<Collection<ProjectRelease>> getOriginReleaseBuilders() {
        ArrayList<Collection<ProjectRelease>> result = new ArrayList<Collection<ProjectRelease>>(this.originBuilders.size());
        for (ReleaseOriginBuilder originReleases : this.originBuilders.values()) {
            if (originReleases.isAlignConstraints()) {
                ArrayList<ProjectRelease> releases = new ArrayList<ProjectRelease>(originReleases.builders.size());
                for (ProjectRelease.Builder builder : originReleases.builders.values()) {
                    releases.add(builder.build());
                }
                result.add(releases);
                continue;
            }
            for (ProjectRelease.Builder builder : originReleases.builders.values()) {
                result.add(List.of(builder.build()));
            }
        }
        return result;
    }

    void enforce(ProjectDependency preferred, ProjectDependency current) {
        ReleaseOriginBuilder rob = this.originBuilders.get(current.releaseId().getRepository());
        if (rob == null) {
            return;
        }
        ProjectRelease.Builder rb = rob.builders.get(current.releaseId().getValue());
        if (rb == null) {
            return;
        }
        System.out.println("ENFORCED " + String.valueOf(preferred.artifact()) + " for " + String.valueOf(rob.members.keySet()));
        ProjectDependency preferredDep = ProjectDependency.create((ScmRevision)current.releaseId(), (Dependency)current.dependency().setArtifact(current.artifact()));
        rb.add(preferredDep, (d1, d2) -> preferredDep);
    }

    private static class ReleaseOriginBuilder {
        final Map<ArtifactKey, PlatformMember> members = new HashMap<ArtifactKey, PlatformMember>();
        final Map<String, ProjectRelease.Builder> builders = new HashMap<String, ProjectRelease.Builder>();

        private ReleaseOriginBuilder() {
        }

        boolean isAlignConstraints() {
            return this.members.size() > 1 || this.members.values().iterator().next().config().isAlignOwnConstraints();
        }
    }
}

