/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.quarkus.bom.platform.SbomerProductConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class SbomerConfig {
    private String apiVersion;
    private String type;
    private List<SbomerProductConfig> products;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<SbomerProductConfig> getProducts() {
        return this.products;
    }

    public void setProducts(List<SbomerProductConfig> products) {
        this.products = products;
    }

    public void addProduct(SbomerProductConfig product) {
        Objects.requireNonNull(product);
        if (this.products == null) {
            this.products = new ArrayList<SbomerProductConfig>();
        }
        this.products.add(product);
    }

    public void serialize(Path file) {
        Path parent = file.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory " + String.valueOf(parent), e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            SbomerConfig.initYamlMapper().writeValue((Writer)writer, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize SBOMER config", e);
        }
    }

    public static SbomerConfig deserialize(Path yaml) {
        SbomerConfig sbomerConfig;
        block9: {
            if (!Files.exists(yaml, new LinkOption[0])) {
                throw new IllegalArgumentException("File " + String.valueOf(yaml) + " does not exist");
            }
            BufferedReader reader = Files.newBufferedReader(yaml);
            try {
                sbomerConfig = (SbomerConfig)SbomerConfig.initYamlMapper().readValue((Reader)reader, SbomerConfig.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to deserialize " + SbomerConfig.class.getName() + " from " + String.valueOf(yaml), e);
                }
            }
            reader.close();
        }
        return sbomerConfig;
    }

    private static ObjectMapper initYamlMapper() {
        return SbomerConfig.initMapper(new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)));
    }

    private static ObjectMapper initMapper(ObjectMapper mapper) {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

