/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform.version;

import io.quarkus.bom.platform.version.PlatformVersionIncrementor;
import io.quarkus.domino.RhVersionPattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class SpPlatformVersionIncrementor
implements PlatformVersionIncrementor {
    @Override
    public String nextVersion(String groupId, String artifactId, String baseVersion, String lastVersion) {
        String prevBaseVersion;
        DefaultArtifactVersion prevV;
        if (lastVersion == null) {
            return baseVersion;
        }
        Object upstreamBaseVersion = RhVersionPattern.ensureNoRhQualifier((String)baseVersion);
        String rhQualifier = baseVersion.substring(((String)upstreamBaseVersion).length());
        DefaultArtifactVersion v = new DefaultArtifactVersion((String)upstreamBaseVersion);
        if (lastVersion != null && (prevV = new DefaultArtifactVersion(prevBaseVersion = RhVersionPattern.ensureNoRhQualifier((String)lastVersion))).getMajorVersion() == v.getMajorVersion() && prevV.getMinorVersion() == v.getMinorVersion() && prevV.getIncrementalVersion() == v.getIncrementalVersion() && prevV.compareTo((ArtifactVersion)v) > 0) {
            upstreamBaseVersion = prevBaseVersion;
            v = prevV;
        }
        if (v.getQualifier() == null) {
            upstreamBaseVersion = (String)upstreamBaseVersion + ".SP1";
        } else if ("Final".equals(v.getQualifier())) {
            upstreamBaseVersion = ((String)upstreamBaseVersion).replace("Final", "SP1");
        } else if (v.getQualifier().startsWith("SP")) {
            int i = ((String)upstreamBaseVersion).lastIndexOf("SP");
            String suffix = ((String)upstreamBaseVersion).substring(i);
            String number = suffix.substring(2);
            String newSuffix = "SP" + (Integer.parseInt(number) + 1);
            upstreamBaseVersion = ((String)upstreamBaseVersion).replace(suffix, newSuffix);
        } else {
            upstreamBaseVersion = (String)upstreamBaseVersion + ".SP1";
        }
        return rhQualifier.isEmpty() ? upstreamBaseVersion : (String)upstreamBaseVersion + "-redhat-00001";
    }
}

