/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.platform.ExtensionCoordsFilter;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.devtools.messagewriter.MessageWriter;
import org.eclipse.aether.artifact.Artifact;

public class ExtensionCoordsFilterFactory {
    private final boolean enableNonMemberQuarkiverseExtensions;

    public static ExtensionCoordsFilterFactory newInstance(PlatformBomConfig config, MessageWriter log) {
        return new ExtensionCoordsFilterFactory(config.isEnableNonMemberQuarkiverseExtensions());
    }

    private ExtensionCoordsFilterFactory(boolean enableNonMemberQuarkiverseExtensions) {
        this.enableNonMemberQuarkiverseExtensions = enableNonMemberQuarkiverseExtensions;
    }

    public ExtensionCoordsFilter forMember(final PlatformBomMemberConfig member) {
        return new ExtensionCoordsFilter(){

            @Override
            public boolean isExcludeFromBom(Artifact a) {
                if (member.originalBomArtifact().getGroupId().equals(a.getGroupId())) {
                    return false;
                }
                return !ExtensionCoordsFilterFactory.this.enableNonMemberQuarkiverseExtensions && a.getGroupId().startsWith("io.quarkiverse");
            }
        };
    }
}

