/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.platform.ExtensionDeps;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bom.platform.PlatformMemberExtensions;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

public class ExtensionFilter
implements DecomposedBomTransformer {
    private static ExtensionFilter noop;
    private final ArtifactResolver resolver;
    private final MessageWriter log;
    private final PlatformBomMemberConfig memberConfig;
    private Set<AppArtifactKey> filteredOutDeps = Collections.emptySet();

    static ExtensionFilter getInstance(ArtifactResolver resolver, MessageWriter log, PlatformBomMemberConfig memberConfig) {
        if (memberConfig.getExtensionCatalog().isEmpty()) {
            return ExtensionFilter.noop();
        }
        return new ExtensionFilter(resolver, log, memberConfig);
    }

    static ExtensionFilter noop() {
        if (noop == null) {
            noop = new ExtensionFilter(null, null, null){

                @Override
                public DecomposedBom transform(DecomposedBom decomposed) throws BomDecomposerException {
                    return decomposed;
                }
            };
        }
        return noop;
    }

    public ExtensionFilter(ArtifactResolver resolver, MessageWriter log, PlatformBomMemberConfig memberConfig) {
        this.resolver = resolver;
        this.log = log;
        this.memberConfig = memberConfig;
    }

    public DecomposedBom transform(DecomposedBom decomposed) throws BomDecomposerException {
        ArrayList<Dependency> allDepList = new ArrayList<Dependency>();
        final HashMap<AppArtifactKey, ProjectDependency> allDepMap = new HashMap<AppArtifactKey, ProjectDependency>();
        final HashMap<Object, ProjectRelease> releaseMap = new HashMap<Object, ProjectRelease>();
        HashMap<ReleaseId, ProjectRelease> releases = new HashMap<ReleaseId, ProjectRelease>();
        for (ProjectRelease r : decomposed.releases()) {
            releases.put(r.id(), r);
            for (ProjectDependency projectDependency : r.dependencies()) {
                allDepList.add(projectDependency.dependency());
                AppArtifactKey key = projectDependency.key();
                allDepMap.put(key, projectDependency);
                releaseMap.put(key, r);
            }
        }
        final HashMap<AppArtifactKey, AtomicInteger> depCounter = new HashMap<AppArtifactKey, AtomicInteger>();
        PlatformMemberExtensions memberExt = new PlatformMemberExtensions(this.memberConfig);
        for (ProjectRelease projectRelease : decomposed.releases()) {
            for (ProjectDependency d : projectRelease.dependencies()) {
                String deploymentStr;
                Path p;
                Artifact a = d.artifact();
                AppArtifactKey extKey = d.key();
                try {
                    p = this.resolver.resolve(a).getArtifact().getFile().toPath();
                }
                catch (Exception e) {
                    this.log.warn("Failed to resolve " + a);
                    allDepMap.remove(extKey);
                    continue;
                }
                if (!p.getFileName().toString().endsWith(".jar")) continue;
                try {
                    FileSystem fs = FileSystems.newFileSystem(p, null);
                    try {
                        Path propsPath = fs.getPath("META-INF/quarkus-extension.properties", new String[0]);
                        if (!Files.exists(propsPath, new LinkOption[0])) continue;
                        Properties props = new Properties();
                        try (BufferedReader reader = Files.newBufferedReader(propsPath);){
                            props.load(reader);
                        }
                        deploymentStr = props.getProperty("deployment-artifact");
                        if (deploymentStr == null) {
                            continue;
                        }
                    }
                    finally {
                        if (fs == null) continue;
                        fs.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new BomDecomposerException("Failed to read META-INF/quarkus-extension.properties from " + p, (Throwable)e);
                }
                AppArtifactCoords deploymentCoords = AppArtifactCoords.fromString((String)deploymentStr);
                final ExtensionDeps ext = new ExtensionDeps(extKey);
                ext.addDeploymentDep(deploymentCoords.getKey());
                AtomicInteger count = depCounter.computeIfAbsent(deploymentCoords.getKey(), k -> new AtomicInteger(0));
                if (this.memberConfig.getExtensionCatalog().contains(extKey)) {
                    count.incrementAndGet();
                }
                allDepMap.remove(deploymentCoords.getKey());
                allDepMap.remove(extKey);
                final AtomicBoolean runtimeCp = new AtomicBoolean(false);
                DependencyVisitor visitor = new DependencyVisitor(){

                    public boolean visitEnter(DependencyNode node) {
                        if (node.getDependency() == null) {
                            return true;
                        }
                        Artifact a = node.getDependency().getArtifact();
                        AppArtifactKey key = ExtensionFilter.key(a);
                        depCounter.computeIfAbsent(key, k -> new AtomicInteger(0)).incrementAndGet();
                        allDepMap.remove(key);
                        if (runtimeCp.get()) {
                            ext.addRuntimeDep(key);
                        } else {
                            ext.addDeploymentDep(key);
                        }
                        ProjectRelease r = (ProjectRelease)releaseMap.get(key);
                        if (r != null) {
                            ext.addProjectDep(r);
                            for (ProjectDependency d : r.dependencies()) {
                                allDepMap.remove(d.key());
                            }
                        }
                        return true;
                    }

                    public boolean visitLeave(DependencyNode node) {
                        return true;
                    }
                };
                try {
                    this.resolver.underlyingResolver().collectManagedDependencies((Artifact)new DefaultArtifact(deploymentCoords.getGroupId(), deploymentCoords.getArtifactId(), deploymentCoords.getClassifier(), deploymentCoords.getType(), deploymentCoords.getVersion()), Collections.emptyList(), allDepList, Collections.emptyList(), Collections.emptyList(), new String[]{"test"}).getRoot().accept(visitor);
                }
                catch (BootstrapMavenException e) {
                    throw new BomDecomposerException("Failed to collect dependencies for " + deploymentCoords, (Throwable)e);
                }
                runtimeCp.set(true);
                try {
                    this.resolver.underlyingResolver().collectManagedDependencies(a, Collections.emptyList(), allDepList, Collections.emptyList(), Collections.emptyList(), new String[]{"test"}).getRoot().accept(visitor);
                }
                catch (BootstrapMavenException e) {
                    throw new BomDecomposerException("Failed to collect dependencies for " + a, (Throwable)e);
                }
                memberExt.addExtension(ext);
            }
        }
        for (ExtensionDeps extensionDeps : memberExt.getFilteredOutExtensions()) {
            AtomicInteger c;
            for (AppArtifactKey key : extensionDeps.getRuntimeDeps()) {
                c = (AtomicInteger)depCounter.get(key);
                if (c.get() <= 0) continue;
                c.decrementAndGet();
            }
            for (AppArtifactKey key : extensionDeps.getDeploymentDeps()) {
                c = (AtomicInteger)depCounter.get(key);
                if (c.get() <= 0) continue;
                c.decrementAndGet();
            }
        }
        this.filteredOutDeps = new HashSet<AppArtifactKey>();
        for (Map.Entry entry : depCounter.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() != 0) continue;
            this.filteredOutDeps.add((AppArtifactKey)entry.getKey());
        }
        DecomposedBom.Builder builder = DecomposedBom.builder().bomArtifact(decomposed.bomArtifact());
        for (ProjectDependency d : allDepMap.values()) {
            ProjectRelease r = (ProjectRelease)releases.remove(d.releaseId());
            if (r == null) continue;
            this.addProjectRelease(builder, r);
        }
        for (AppArtifactKey extKey : this.memberConfig.getExtensionCatalog()) {
            ExtensionDeps ext = memberExt.getExtension(extKey);
            for (ProjectRelease r : ext.getProjectDeps()) {
                if (releases.remove(r.id()) == null) continue;
                this.addProjectRelease(builder, r);
            }
        }
        return builder.build();
    }

    private void addProjectRelease(DecomposedBom.Builder builder, ProjectRelease r) {
        ProjectRelease.Builder prb = ProjectRelease.builder((ReleaseId)r.id());
        for (ProjectDependency pd : r.dependencies()) {
            if (this.isFilteredOut(pd.key())) continue;
            prb.add(pd);
        }
        builder.addRelease(prb.build());
    }

    boolean isFilteredOut(AppArtifactKey key) {
        return this.filteredOutDeps.contains(key);
    }

    private static AppArtifactKey key(Artifact a) {
        return new AppArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }
}

