/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.platform.ExtensionCoordsFilter;
import io.quarkus.bom.platform.ExtensionCoordsFilterFactory;
import io.quarkus.bom.platform.ExtensionFilter;
import io.quarkus.bom.platform.NotPreferredQuarkusBomConstraint;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bom.platform.ProjectReleaseCollector;
import io.quarkus.bom.platform.VersionConstraintComparator;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.registry.util.GlobUtil;
import io.quarkus.registry.util.PlatformArtifacts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class PlatformBomComposer
implements DecomposedBomTransformer,
DecomposedBomVisitor {
    private final DecomposedBom originalQuarkusBom;
    private final DecomposedBom filteredQuarkusBom;
    private final DecomposedBom generatedQuarkusBom;
    private final MessageWriter logger;
    private final ExtensionCoordsFilterFactory extCoordsFilterFactory;
    private ArtifactResolver resolver;
    private Collection<ReleaseVersion> quarkusVersions;
    private LinkedHashMap<String, ReleaseId> preferredVersions;
    private boolean transformingBom;
    private Map<AppArtifactKey, ProjectDependency> quarkusBomDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private final ProjectReleaseCollector extReleaseCollector = new ProjectReleaseCollector();
    final Map<AppArtifactKey, ProjectDependency> externalExtensionDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private List<DecomposedBom> importedBoms = new ArrayList<DecomposedBom>();
    private Map<Artifact, DecomposedBom> originalImportedBoms = new HashMap<Artifact, DecomposedBom>();
    private Set<Artifact> bomsNotImportingQuarkusBom = new HashSet<Artifact>();
    private final DecomposedBom platformBom;
    private Map<String, PlatformBomMemberConfig> memberConfigs = new HashMap<String, PlatformBomMemberConfig>();
    private PlatformBomConfig config;
    private VersionConstraintComparator versionComparator;
    private PlatformBomMemberConfig memberBeingProcessed;
    private Artifact extBom;

    public static DecomposedBom compose(PlatformBomConfig config) throws BomDecomposerException {
        return new PlatformBomComposer(config).platformBom();
    }

    public PlatformBomComposer(PlatformBomConfig config) throws BomDecomposerException {
        this(config, MessageWriter.info());
    }

    public PlatformBomComposer(PlatformBomConfig config, MessageWriter logger) throws BomDecomposerException {
        this.config = config;
        this.logger = logger;
        this.resolver = config.artifactResolver();
        this.extCoordsFilterFactory = ExtensionCoordsFilterFactory.newInstance(config, logger);
        this.originalQuarkusBom = BomDecomposer.config().logger(logger).mavenArtifactResolver(this.resolver()).bomArtifact(config.quarkusBom().originalBomArtifact()).decompose();
        ExtensionFilter coreFilter = ExtensionFilter.getInstance(this.resolver(), logger, config.quarkusBom());
        this.filteredQuarkusBom = coreFilter.transform(this.originalQuarkusBom);
        DecomposedBom.Builder quarkusBomBuilder = DecomposedBom.builder().bomArtifact(config.quarkusBom().generatedBomArtifact()).bomSource(PomSource.of((Artifact)config.quarkusBom().generatedBomArtifact()));
        this.addPlatformArtifacts(config.quarkusBom(), quarkusBomBuilder);
        this.filteredQuarkusBom.releases().forEach(r -> {
            AtomicReference rbRef = new AtomicReference();
            r.dependencies().forEach(d -> {
                ProjectDependency effectiveDep = this.effectiveDep((ProjectDependency)d);
                if (effectiveDep != null) {
                    ProjectRelease.Builder rb = (ProjectRelease.Builder)rbRef.get();
                    if (rb == null) {
                        rb = ProjectRelease.builder((ReleaseId)r.id());
                        rbRef.set(rb);
                    }
                    rb.add(effectiveDep);
                    this.quarkusBomDeps.put(effectiveDep.key(), effectiveDep);
                } else {
                    this.quarkusBomDeps.put(d.key(), (ProjectDependency)d);
                }
            });
            ProjectRelease.Builder rb = (ProjectRelease.Builder)rbRef.get();
            if (rb != null) {
                quarkusBomBuilder.addRelease(rb.build());
            }
        });
        this.generatedQuarkusBom = quarkusBomBuilder.build();
        for (PlatformBomMemberConfig memberConfig : config.directDeps()) {
            logger.info("Processing " + (memberConfig.originalBomArtifact() == null ? memberConfig.generatedBomArtifact() : memberConfig.originalBomArtifact()));
            this.memberBeingProcessed = memberConfig;
            this.memberConfigs.put(memberConfig.key(), memberConfig);
            this.transformingBom = memberConfig.isBom() || memberConfig.asDependencyConstraints().size() > 1;
            Collection<Dependency> bomDeps = memberConfig.isBom() ? this.managedDepsExcludingQuarkusBom(memberConfig) : memberConfig.asDependencyConstraints();
            DecomposedBom originalBom = BomDecomposer.config().mavenArtifactResolver(this.resolver()).dependencies(bomDeps).logger(logger).bomArtifact(memberConfig.originalBomArtifact() == null ? memberConfig.generatedBomArtifact() : memberConfig.originalBomArtifact()).decompose();
            originalBom = ExtensionFilter.getInstance(this.resolver(), logger, memberConfig).transform(originalBom);
            if (memberConfig.isBom()) {
                this.originalImportedBoms.put(originalBom.bomArtifact(), originalBom);
            } else if (memberConfig.asDependencyConstraints().size() > 1) {
                this.originalImportedBoms.put(memberConfig.generatedBomArtifact(), originalBom);
            }
            this.transform(originalBom);
        }
        logger.info("Generating " + config.bomArtifact());
        this.platformBom = this.generatePlatformBom();
        this.generatedUpdatedImportedBoms();
    }

    public DecomposedBom originalQuarkusCoreBom() {
        return this.originalQuarkusBom;
    }

    public DecomposedBom generatedQuarkusCoreBom() {
        return this.generatedQuarkusBom;
    }

    public DecomposedBom platformBom() {
        return this.platformBom;
    }

    public List<DecomposedBom> alignedMemberBoms() {
        return this.importedBoms;
    }

    public DecomposedBom originalMemberBom(Artifact artifact) {
        return this.originalImportedBoms.get(artifact);
    }

    private void generatedUpdatedImportedBoms() {
        HashSet<AppArtifactKey> bomDeps = new HashSet<AppArtifactKey>();
        HashMap<ReleaseId, ProjectRelease.Builder> releaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        int i = 0;
        while (i < this.importedBoms.size()) {
            bomDeps.clear();
            releaseBuilders.clear();
            DecomposedBom importedBomMinusQuarkusBom = this.importedBoms.get(i);
            for (ProjectRelease release : importedBomMinusQuarkusBom.releases()) {
                for (ProjectDependency dep : release.dependencies()) {
                    if (!bomDeps.add(dep.key()) || this.config.excluded(dep.key())) continue;
                    ProjectDependency platformDep = this.quarkusBomDeps.get(dep.key());
                    if (platformDep == null) {
                        platformDep = this.externalExtensionDeps.get(dep.key());
                    }
                    if (platformDep == null) {
                        throw new IllegalStateException("Failed to locate " + dep.key() + " in the generated platform BOM");
                    }
                    releaseBuilders.computeIfAbsent(platformDep.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(platformDep);
                }
            }
            PlatformBomMemberConfig memberConfig = this.memberConfigs.get(importedBomMinusQuarkusBom.bomArtifact().getGroupId() + ":" + importedBomMinusQuarkusBom.bomArtifact().getArtifactId());
            Artifact generatedBomArtifact = memberConfig.generatedBomArtifact();
            DecomposedBom.Builder updatedBom = DecomposedBom.builder().bomArtifact(generatedBomArtifact).bomSource(PomSource.of((Artifact)generatedBomArtifact));
            for (ProjectRelease.Builder releaseBuilder : releaseBuilders.values()) {
                updatedBom.addRelease(releaseBuilder.build());
            }
            this.addPlatformArtifacts(memberConfig, updatedBom);
            this.importedBoms.set(i++, updatedBom.build());
        }
    }

    private void addPlatformArtifacts(PlatformBomMemberConfig memberConfig, DecomposedBom.Builder updatedBom) {
        Artifact generatedBomArtifact = memberConfig.generatedBomArtifact();
        if (!generatedBomArtifact.equals(memberConfig.originalBomArtifact())) {
            ReleaseId memberReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)generatedBomArtifact.getGroupId(), (String)generatedBomArtifact.getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)generatedBomArtifact.getVersion()));
            ProjectRelease memberRelease = ProjectRelease.builder((ReleaseId)memberReleaseId).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-descriptor", generatedBomArtifact.getVersion(), "json", generatedBomArtifact.getVersion()))).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-properties", null, "properties", generatedBomArtifact.getVersion()))).build();
            updatedBom.addRelease(memberRelease);
        }
    }

    private DecomposedBom generatePlatformBom() throws BomDecomposerException {
        HashMap<ReleaseId, ProjectRelease.Builder> platformReleaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        ReleaseId bomReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)this.config.bomArtifact().getGroupId(), (String)this.config.bomArtifact().getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)this.config.bomArtifact().getVersion()));
        ProjectRelease.Builder bomReleaseBuilder = ProjectRelease.builder((ReleaseId)bomReleaseId).add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-descriptor", this.config.bomArtifact().getVersion(), "json", this.config.bomArtifact().getVersion())));
        if (this.config.includePlatformProperties()) {
            bomReleaseBuilder.add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-properties", null, "properties", this.config.bomArtifact().getVersion())));
        }
        platformReleaseBuilders.put(bomReleaseId, bomReleaseBuilder);
        for (ProjectDependency projectDependency : this.quarkusBomDeps.values()) {
            ProjectDependency projectDependency2 = this.effectiveDep(projectDependency);
            if (projectDependency2 == null) continue;
            platformReleaseBuilders.computeIfAbsent(projectDependency2.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency2);
        }
        for (Collection collection : this.extReleaseCollector.getOriginReleaseBuilders()) {
            if (collection.size() == 1) {
                this.mergeExtensionDeps((ProjectRelease)collection.iterator().next(), this.externalExtensionDeps);
                continue;
            }
            LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions(collection);
            block2: for (ProjectRelease release : collection) {
                for (Map.Entry<String, ReleaseId> preferred : preferredVersions.entrySet()) {
                    if (release.id().equals(preferred.getValue())) {
                        this.mergeExtensionDeps(release, this.externalExtensionDeps);
                        continue block2;
                    }
                    for (ProjectDependency dep : release.dependencies()) {
                        if (this.quarkusBomDeps.containsKey(dep.key())) continue;
                        String depVersion = dep.artifact().getVersion();
                        if (!preferred.getKey().equals(depVersion)) {
                            for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                                Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                                if (this.resolver().resolveOrNull(artifact) == null) continue;
                                dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                                break;
                            }
                        }
                        this.addNonQuarkusDep(dep, this.externalExtensionDeps);
                    }
                }
            }
        }
        for (ProjectDependency projectDependency : this.externalExtensionDeps.values()) {
            platformReleaseBuilders.computeIfAbsent(projectDependency.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency);
        }
        DecomposedBom.Builder platformBuilder = DecomposedBom.builder().bomArtifact(this.config.bomArtifact()).bomSource(this.config.bomResolver());
        for (ProjectRelease.Builder builder : platformReleaseBuilders.values()) {
            platformBuilder.addRelease(builder.build());
        }
        return platformBuilder.build();
    }

    private ProjectDependency effectiveDep(ProjectDependency dep) {
        if (this.config.excluded(dep.key())) {
            return null;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced == null) {
            return dep;
        }
        return ProjectDependency.create((ReleaseId)dep.releaseId(), (Dependency)dep.dependency().setArtifact(enforced));
    }

    private void mergeExtensionDeps(ProjectRelease release, Map<AppArtifactKey, ProjectDependency> extensionDeps) throws BomDecomposerException {
        for (ProjectDependency dep : release.dependencies()) {
            ProjectDependency quarkusBomDep = this.quarkusBomDeps.get(dep.key());
            if (quarkusBomDep != null) {
                this.quarkusBomDependencyInMemberBom(quarkusBomDep, dep);
                return;
            }
            this.addNonQuarkusDep(dep, extensionDeps);
        }
    }

    private void addNonQuarkusDep(ProjectDependency dep, Map<AppArtifactKey, ProjectDependency> extensionDeps) {
        if (this.config.excluded(dep.key())) {
            return;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced != null) {
            if (!extensionDeps.containsKey(dep.key())) {
                extensionDeps.put(dep.key(), ProjectDependency.create((ReleaseId)dep.releaseId(), (Artifact)enforced));
            }
            return;
        }
        ProjectDependency currentDep = extensionDeps.get(dep.key());
        if (currentDep != null) {
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(currentDep.artifact().getVersion());
            DefaultArtifactVersion newVersion = new DefaultArtifactVersion(dep.artifact().getVersion());
            if (this.versionConstraintComparator().compare((ArtifactVersion)currentVersion, (ArtifactVersion)newVersion) < 0) {
                extensionDeps.put(dep.key(), dep);
            }
        } else {
            extensionDeps.put(dep.key(), dep);
        }
    }

    public DecomposedBom transform(DecomposedBom decomposedBom) throws BomDecomposerException {
        if (this.transformingBom) {
            this.importedBoms.add(decomposedBom);
        }
        decomposedBom.visit((DecomposedBomVisitor)this);
        return decomposedBom;
    }

    public void enterBom(Artifact bomArtifact) {
        this.extBom = bomArtifact;
    }

    public boolean enterReleaseOrigin(ReleaseOrigin releaseOrigin, int versions) {
        this.preferredVersions = null;
        this.quarkusVersions = this.filteredQuarkusBom.releaseVersions(releaseOrigin);
        return true;
    }

    public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
    }

    public void visitProjectRelease(ProjectRelease release) throws BomDecomposerException {
        if (this.quarkusVersions.isEmpty()) {
            ProjectRelease.Builder releaseBuilder = this.extReleaseCollector.getOrCreateReleaseBuilder(release.id(), this.memberBeingProcessed);
            for (ProjectDependency dep : release.dependencies()) {
                releaseBuilder.add(dep);
            }
            return;
        }
        if (this.quarkusVersions.contains(release.id().version())) {
            for (ProjectDependency dep : release.dependencies()) {
                ProjectDependency quarkusBomDep = this.quarkusBomDeps.putIfAbsent(dep.key(), dep);
                if (quarkusBomDep == null) continue;
                this.quarkusBomDependencyInMemberBom(quarkusBomDep, dep);
            }
            return;
        }
        LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions == null ? (this.preferredVersions = this.preferredVersions(this.filteredQuarkusBom.releases(release.id().origin()))) : this.preferredVersions;
        Iterator iterator = release.dependencies().iterator();
        while (iterator.hasNext()) {
            ProjectDependency quarkusBomDep;
            ProjectDependency memberDep;
            ProjectDependency preferredDep = memberDep = (ProjectDependency)iterator.next();
            if (!preferredVersions.containsKey(memberDep.artifact().getVersion())) {
                for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                    Artifact artifact = memberDep.artifact().setVersion(preferredVersion.getKey());
                    if (this.resolver().resolveOrNull(artifact) == null) continue;
                    preferredDep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)memberDep.dependency().setArtifact(artifact));
                    break;
                }
            }
            if ((quarkusBomDep = this.quarkusBomDeps.putIfAbsent(preferredDep.key(), preferredDep)) == null) continue;
            this.quarkusBomDependencyInMemberBom(quarkusBomDep, memberDep);
        }
    }

    private void quarkusBomDependencyInMemberBom(ProjectDependency quarkusBomDep, ProjectDependency memberDep) throws BomDecomposerException {
        if (!quarkusBomDep.artifact().getVersion().equals(memberDep.artifact().getVersion()) && this.versionConstraintComparator().hasVersionPreferences() && this.versionConstraintComparator().isPreferredVersion((ArtifactVersion)new DefaultArtifactVersion(memberDep.artifact().getVersion())) && !this.versionConstraintComparator().isPreferredVersion((ArtifactVersion)new DefaultArtifactVersion(quarkusBomDep.artifact().getVersion()))) {
            StringBuilder buf = new StringBuilder();
            buf.append("Preferred constraint ").append(memberDep.artifact()).append(" was rejected in favor of ").append(quarkusBomDep.artifact()).append(" managed by the quarkus-bom");
            if (this.config.notPreferredQuarkusBomConstraint() == NotPreferredQuarkusBomConstraint.ERROR) {
                throw new BomDecomposerException(buf.toString());
            }
            if (this.config.notPreferredQuarkusBomConstraint() == NotPreferredQuarkusBomConstraint.WARN) {
                this.logger.warn(buf.toString());
            }
        }
    }

    public void leaveBom() throws BomDecomposerException {
    }

    private VersionConstraintComparator versionConstraintComparator() {
        if (this.versionComparator == null) {
            List<Pattern> preferences;
            if (this.config.versionConstraintPreferences().isEmpty()) {
                preferences = Collections.emptyList();
            } else {
                preferences = new ArrayList<Pattern>(this.config.versionConstraintPreferences().size());
                for (String expr : this.config.versionConstraintPreferences()) {
                    preferences.add(Pattern.compile(GlobUtil.toRegexPattern((String)expr)));
                }
            }
            this.versionComparator = new VersionConstraintComparator(preferences);
        }
        return this.versionComparator;
    }

    private LinkedHashMap<String, ReleaseId> preferredVersions(Collection<ProjectRelease> releases) {
        TreeMap<ArtifactVersion, ReleaseId> treeMap = new TreeMap<ArtifactVersion, ReleaseId>(Collections.reverseOrder(this.versionConstraintComparator()));
        for (ProjectRelease release : releases) {
            for (String versionStr : release.artifactVersions()) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                ReleaseId prevReleaseId = treeMap.put((ArtifactVersion)version, release.id());
                if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.version().asString()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString())) <= 0) continue;
                treeMap.put((ArtifactVersion)version, prevReleaseId);
            }
        }
        LinkedHashMap<String, ReleaseId> result = new LinkedHashMap<String, ReleaseId>(treeMap.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            result.put(entry.getKey().toString(), (ReleaseId)entry.getValue());
        }
        return result;
    }

    private Collection<Dependency> managedDepsExcludingQuarkusBom(PlatformBomMemberConfig member) throws BomDecomposerException {
        Artifact bom = member.originalBomArtifact();
        ArtifactDescriptorResult bomDescr = this.describe(bom);
        ArrayList<DefaultArtifact> importedPlatformBoms = null;
        List allDeps = bomDescr.getManagedDependencies();
        HashMap<AppArtifactKey, Dependency> result = new HashMap<AppArtifactKey, Dependency>(allDeps.size());
        ExtensionCoordsFilter extCoordsFilter = this.extCoordsFilterFactory.forMember(member);
        for (Dependency dependency : allDeps) {
            Artifact artifact = dependency.getArtifact();
            if (PlatformArtifacts.isCatalogArtifactId((String)artifact.getArtifactId())) {
                if (importedPlatformBoms == null) {
                    importedPlatformBoms = new ArrayList<DefaultArtifact>(2);
                }
                importedPlatformBoms.add(new DefaultArtifact(artifact.getGroupId(), PlatformArtifacts.ensureBomArtifactId((String)artifact.getArtifactId()), "pom", artifact.getVersion()));
            }
            if (extCoordsFilter.isExcludeFromBom(artifact)) continue;
            result.put(PlatformBomComposer.key(artifact), dependency);
        }
        if (importedPlatformBoms != null) {
            for (Artifact artifact : importedPlatformBoms) {
                this.subtractPlatformBom(result, artifact);
            }
        } else {
            this.bomsNotImportingQuarkusBom.add(bom);
        }
        return result.values();
    }

    private static AppArtifactKey key(Artifact artifact) {
        return new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
    }

    private void subtractPlatformBom(Map<AppArtifactKey, Dependency> result, Artifact quarkusCoreBom) throws BomDecomposerException {
        try {
            ArtifactDescriptorResult quarkusBomDescr = this.describe(quarkusCoreBom);
            for (Dependency quarkusBomDep : quarkusBomDescr.getManagedDependencies()) {
                result.remove(PlatformBomComposer.key(quarkusBomDep.getArtifact()));
            }
        }
        catch (BomDecomposerException e) {
            this.logger.debug("Failed to subtract %s: %s", new Object[]{quarkusCoreBom, e.getLocalizedMessage()});
            throw e;
        }
    }

    private ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        return this.resolver().describe(artifact);
    }

    private ArtifactResolver resolver() {
        return this.resolver == null ? (this.resolver = ArtifactResolverProvider.get()) : this.resolver;
    }
}

