/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.platform.NotPreferredQuarkusBomConstraint;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.registry.util.PlatformArtifacts;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Exclusion;

public class PlatformBomConfig {
    private PomResolver bomResolver;
    private Artifact bomArtifact;
    private boolean includePlatformProperties;
    private PlatformBomMemberConfig quarkusBom;
    private List<PlatformBomMemberConfig> directDeps = new ArrayList<PlatformBomMemberConfig>();
    private Map<AppArtifactKey, Artifact> enforced = new HashMap<AppArtifactKey, Artifact>(0);
    private Set<AppArtifactKey> excluded = new HashSet<AppArtifactKey>(0);
    private Set<String> excludedGroups = new HashSet<String>(0);
    private boolean enableNonMemberQuarkiverseExtensions;
    private ArtifactResolver artifactResolver;
    private List<String> versionConstraintPreferences = Collections.emptyList();
    private NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint = NotPreferredQuarkusBomConstraint.ERROR;

    public static Builder builder() {
        return new Builder();
    }

    public static PlatformBomConfig forPom(PomResolver pomResolver) {
        return PlatformBomConfig.builder().pomResolver(pomResolver).build();
    }

    private PlatformBomConfig() {
    }

    public PomResolver bomResolver() {
        return this.bomResolver;
    }

    public Artifact bomArtifact() {
        return this.bomArtifact;
    }

    public boolean includePlatformProperties() {
        return this.includePlatformProperties;
    }

    public PlatformBomMemberConfig quarkusBom() {
        return this.quarkusBom;
    }

    public List<PlatformBomMemberConfig> directDeps() {
        return this.directDeps;
    }

    public boolean hasEnforced() {
        return !this.enforced.isEmpty();
    }

    public Map<AppArtifactKey, Artifact> enforced() {
        return this.enforced;
    }

    public Artifact enforced(AppArtifactKey key) {
        return this.enforced.get(key);
    }

    public boolean hasExcluded() {
        return !this.excluded.isEmpty();
    }

    public Set<AppArtifactKey> excluded() {
        return this.excluded;
    }

    public boolean isEnableNonMemberQuarkiverseExtensions() {
        return this.enableNonMemberQuarkiverseExtensions;
    }

    public ArtifactResolver artifactResolver() {
        return this.artifactResolver;
    }

    public List<String> versionConstraintPreferences() {
        return this.versionConstraintPreferences;
    }

    public NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint() {
        return this.notPreferredQuarkusBomConstraint;
    }

    boolean excluded(AppArtifactKey key) {
        return this.excluded.contains(key) ? true : this.excludedGroups.contains(key.getGroupId());
    }

    public static class Builder {
        final PlatformBomConfig config = new PlatformBomConfig();

        private Builder() {
        }

        public Builder platformBom(Artifact platformBom) {
            this.config.bomArtifact = platformBom;
            return this;
        }

        public Builder includePlatformProperties(boolean includePlatformProperties) {
            this.config.includePlatformProperties = includePlatformProperties;
            return this;
        }

        public Builder importBom(PlatformBomMemberConfig member) {
            if (member.originalBomArtifact() != null && member.originalBomArtifact().getArtifactId().equals("quarkus-bom") && member.originalBomArtifact().getGroupId().equals("io.quarkus")) {
                this.config.quarkusBom = member;
            } else {
                this.config.directDeps().add(member);
            }
            return this;
        }

        public Builder pomResolver(PomResolver pomResolver) {
            this.config.bomResolver = pomResolver;
            return this;
        }

        public Builder enforce(Artifact artifact) {
            this.config.enforced.put(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()), artifact);
            return this;
        }

        public Builder excludeGroupId(String groupId) {
            this.config.excludedGroups.add(groupId);
            return this;
        }

        public Builder exclude(String groupId, String artifactId) {
            return this.exclude(new AppArtifactKey(groupId, artifactId, null, "jar"));
        }

        public Builder exclude(AppArtifactKey key) {
            this.config.excluded.add(key);
            return this;
        }

        public Builder enableNonMemberQuarkiverseExtensions(boolean enableNonMemberQuarkiverseExtensions) {
            this.config.enableNonMemberQuarkiverseExtensions = enableNonMemberQuarkiverseExtensions;
            return this;
        }

        public Builder artifactResolver(ArtifactResolver resolver) {
            this.config.artifactResolver = resolver;
            return this;
        }

        public Builder versionConstraintPreference(List<String> preferences) {
            this.config.versionConstraintPreferences = preferences;
            return this;
        }

        public Builder notPreferredQuarkusBomConstraint(NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint) {
            this.config.notPreferredQuarkusBomConstraint = notPreferredQuarkusBomConstraint;
            return this;
        }

        public PlatformBomConfig build() {
            Objects.requireNonNull(this.config.bomResolver);
            if (this.config.bomArtifact != null && this.config.quarkusBom != null) {
                return this.config;
            }
            Path pom = this.config.bomResolver.pomPath();
            try {
                Path parentPom;
                Model parentModel;
                String relativePath;
                Model model = this.config.bomResolver.readLocalModel(pom);
                DependencyManagement dm = model.getDependencyManagement();
                if (dm == null) {
                    throw new Exception(pom + " does not include managed dependencies");
                }
                Properties allProps = new Properties();
                allProps.putAll((Map<?, ?>)model.getProperties());
                Parent parent = model.getParent();
                while (parent != null && (relativePath = parent.getRelativePath()) != null && !relativePath.isEmpty() && (parentModel = this.config.bomResolver.readLocalModel(parentPom = pom.getParent().resolve(relativePath).normalize().toAbsolutePath())) != null) {
                    allProps.putAll((Map<?, ?>)parentModel.getProperties());
                    parent = parentModel.getParent();
                    pom = parentPom;
                }
                allProps.setProperty("project.version", ModelUtils.getVersion((Model)model));
                this.config.bomArtifact = (Artifact)Objects.requireNonNull(new DefaultArtifact(ModelUtils.getGroupId((Model)model), model.getArtifactId(), null, "pom", ModelUtils.getVersion((Model)model)));
                for (Dependency dep : dm.getDependencies()) {
                    if (dep.getArtifactId().startsWith(this.config.bomArtifact.getArtifactId()) && PlatformArtifacts.isCatalogArtifactId((String)dep.getArtifactId())) continue;
                    DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), Builder.resolveExpr(allProps, dep.getClassifier()), dep.getType(), Builder.resolveExpr(allProps, dep.getVersion()));
                    ArrayList<Exclusion> aetherExclusions = null;
                    if (!dep.getExclusions().isEmpty()) {
                        aetherExclusions = new ArrayList<Exclusion>(dep.getExclusions().size());
                        for (org.apache.maven.model.Exclusion e : dep.getExclusions()) {
                            aetherExclusions.add(new Exclusion(e.getGroupId(), e.getArtifactId(), null, null));
                        }
                    }
                    org.eclipse.aether.graph.Dependency aetherDep = new org.eclipse.aether.graph.Dependency((Artifact)artifact, dep.getScope(), Boolean.valueOf(dep.getOptional() != null && Boolean.parseBoolean(dep.getOptional())), aetherExclusions);
                    if (this.config.quarkusBom == null && dep.getArtifactId().equals("quarkus-bom") && dep.getGroupId().equals("io.quarkus")) {
                        this.config.quarkusBom = new PlatformBomMemberConfig(aetherDep);
                        continue;
                    }
                    this.config.directDeps.add(new PlatformBomMemberConfig(aetherDep));
                }
                if (this.config.quarkusBom == null) {
                    throw new RuntimeException("Failed to locate io.quarkus:quarkus-bom among the dependencies");
                }
                return this.config;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize platform BOM config", e);
            }
        }

        private static String resolveExpr(Properties allProps, String expr) {
            String prop;
            String value;
            if (expr != null && expr.startsWith("${") && expr.endsWith("}") && (value = allProps.getProperty(prop = expr.substring(2, expr.length() - 1))) != null) {
                return value;
            }
            return expr;
        }
    }
}

