/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bootstrap.model.AppArtifactKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public class PlatformBomMemberConfig {
    private final Dependency bomDep;
    private final List<Dependency> dm;
    private String key;
    private Artifact generatedBomArtifact;
    private Collection<AppArtifactKey> extensionCatalog = Collections.emptyList();
    private boolean alignOwnConstraints;

    public PlatformBomMemberConfig(Dependency bomDep) {
        this.bomDep = bomDep;
        this.dm = Collections.singletonList(bomDep);
        this.generatedBomArtifact = bomDep == null ? null : bomDep.getArtifact();
        this.key = bomDep.getArtifact().getGroupId() + ":" + bomDep.getArtifact().getArtifactId();
    }

    public PlatformBomMemberConfig(List<Dependency> dm) {
        this.bomDep = null;
        this.dm = dm;
    }

    public String key() {
        if (this.key == null) {
            this.key = this.bomDep == null ? this.generatedBomArtifact.getGroupId() + ":" + this.generatedBomArtifact.getArtifactId() : this.bomDep.getArtifact().getGroupId() + ":" + this.bomDep.getArtifact().getArtifactId();
        }
        return this.key;
    }

    public void setGeneratedBomArtifact(Artifact generatedBomArtifact) {
        this.generatedBomArtifact = generatedBomArtifact;
    }

    public Artifact originalBomArtifact() {
        return this.bomDep == null ? null : this.bomDep.getArtifact();
    }

    public Artifact generatedBomArtifact() {
        return this.generatedBomArtifact;
    }

    public boolean isBom() {
        return this.bomDep == null ? false : this.bomDep.getScope().equals("import");
    }

    public List<Dependency> asDependencyConstraints() {
        return this.dm;
    }

    public void setExtensionCatalog(Collection<AppArtifactKey> extensionCatalog) {
        this.extensionCatalog = extensionCatalog;
    }

    public Collection<AppArtifactKey> getExtensionCatalog() {
        return this.extensionCatalog;
    }

    public boolean isAlignOwnConstraints() {
        return this.alignOwnConstraints;
    }

    public void setAlignOwnConstraints(boolean alignOwnConstraints) {
        this.alignOwnConstraints = alignOwnConstraints;
    }
}

